/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum TouchScreen implements ResourceEnum
{
    NOTOUCH("notouch", "No Touch", "No-touch screen"),
    STYLUS("stylus", "Stylus", "Stylus-based touchscreen"),
    FINGER("finger", "Finger", "Finger-based touchscreen");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private TouchScreen(String value, String displayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = displayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static TouchScreen getEnum(String value) {
        for (TouchScreen orient : TouchScreen.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(TouchScreen touch) {
        return touch == null ? -1 : touch.ordinal();
    }

    public static TouchScreen getByIndex(int index) {
        TouchScreen[] values2 = TouchScreen.values();
        if (index >= 0 && index < values2.length) {
            return values2[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

