/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum ScreenOrientation implements ResourceEnum
{
    PORTRAIT("port", "Portrait", "Portrait Orientation"),
    LANDSCAPE("land", "Landscape", "Landscape Orientation"),
    SQUARE("square", "Square", "Square Orientation");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenOrientation(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenOrientation getEnum(String value) {
        for (ScreenOrientation orient : ScreenOrientation.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenOrientation orientation) {
        return orientation == null ? -1 : orientation.ordinal();
    }

    public static ScreenOrientation getByIndex(int index) {
        ScreenOrientation[] values2 = ScreenOrientation.values();
        if (index >= 0 && index < values2.length) {
            return values2[index];
        }
        return null;
    }

    public static ScreenOrientation getByShortDisplayName(String name) {
        for (ScreenOrientation orientation : ScreenOrientation.values()) {
            if (!orientation.getShortDisplayValue().equalsIgnoreCase(name)) continue;
            return orientation;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

