/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum KeyboardState implements ResourceEnum
{
    EXPOSED("keysexposed", "Exposed", "Exposed keyboard"),
    HIDDEN("keyshidden", "Hidden", "Hidden keyboard"),
    SOFT("keyssoft", "Soft", "Soft keyboard");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private KeyboardState(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static KeyboardState getEnum(String value) {
        for (KeyboardState state : KeyboardState.values()) {
            if (!state.mValue.equals(value)) continue;
            return state;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(KeyboardState value) {
        return value == null ? -1 : value.ordinal();
    }

    public static KeyboardState getByIndex(int index) {
        KeyboardState[] values2 = KeyboardState.values();
        if (index >= 0 && index < values2.length) {
            return values2[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

