/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.impl.FileOpImpl;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;

public final class FileOpUtils {
    public static FileOp create() {
        return new FileOpImpl();
    }

    public static void recursiveCopy(File src, File dest, FileOp fop, ProgressIndicator progress) throws IOException {
        FileOpUtils.recursiveCopy(src, dest, false, fop, progress);
    }

    @VisibleForTesting
    static void recursiveCopy(File src, File dest, boolean merge, FileOp fop, ProgressIndicator progress) throws IOException {
        if (fop.exists(dest)) {
            if (!merge) {
                throw new IOException(dest + " already exists!");
            }
            if (fop.isDirectory(src) != fop.isDirectory(dest)) {
                throw new IOException(String.format("%s already exists but %s a directory!", dest, fop.isDirectory(dest) ? "is" : "is not"));
            }
        }
        if (progress.isCanceled()) {
            throw new IOException("Operation cancelled");
        }
        if (fop.isDirectory(src)) {
            File[] children;
            fop.mkdirs(dest);
            for (File child : children = fop.listFiles(src)) {
                File newDest = new File(dest, child.getName());
                FileOpUtils.recursiveCopy(child, newDest, merge, fop, progress);
            }
        } else if (fop.isFile(src) && !fop.exists(dest)) {
            fop.copyFile(src, dest);
            if (!fop.isWindows() && fop.canExecute(src)) {
                fop.setExecutablePermission(dest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void safeRecursiveOverwrite(File src, File dest, FileOp fop, ProgressIndicator progress) throws IOException {
        File destBackup;
        block18: {
            block19: {
                boolean success;
                block17: {
                    destBackup = FileOpUtils.getTempDir(dest, "backup", fop);
                    success = false;
                    try {
                        if (fop.exists(dest)) {
                            FileOpUtils.moveOrCopyAndDelete(dest, destBackup, fop, progress);
                            if (fop.exists(dest)) {
                                throw new IOException(String.format("Failed to move away or delete existing target file: %s%nMove it away manually and try again.", dest));
                            }
                            success = true;
                        }
                        if (success || !fop.exists(destBackup)) break block17;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        if (!fop.exists(destBackup)) throw throwable;
                        try {
                            FileOpUtils.recursiveCopy(destBackup, dest, true, fop, progress);
                            fop.deleteFileOrFolder(destBackup);
                            throw throwable;
                        }
                        catch (IOException e) {
                            progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                        }
                        throw throwable;
                    }
                    try {
                        FileOpUtils.recursiveCopy(destBackup, dest, true, fop, progress);
                        fop.deleteFileOrFolder(destBackup);
                    }
                    catch (IOException e) {
                        progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                    }
                }
                success = false;
                try {
                    FileOpUtils.moveOrCopyAndDelete(src, dest, fop, progress);
                    success = true;
                    if (success) break block18;
                    fop.deleteFileOrFolder(dest);
                    if (!fop.exists(dest)) break block19;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    fop.deleteFileOrFolder(dest);
                    if (fop.exists(dest)) {
                        File toDelete = FileOpUtils.getTempDir(dest, "delete", fop);
                        fop.renameTo(dest, toDelete);
                        fop.deleteOnExit(toDelete);
                    }
                    try {
                        if (fop.exists(dest)) {
                            FileOpUtils.recursiveCopy(destBackup, dest, true, fop, progress);
                            throw throwable;
                        }
                        FileOpUtils.moveOrCopyAndDelete(destBackup, dest, fop, progress);
                        throw throwable;
                    }
                    catch (IOException e) {
                        progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                    }
                    throw throwable;
                }
                File toDelete = FileOpUtils.getTempDir(dest, "delete", fop);
                fop.renameTo(dest, toDelete);
                fop.deleteOnExit(toDelete);
            }
            try {
                if (fop.exists(dest)) {
                    FileOpUtils.recursiveCopy(destBackup, dest, true, fop, progress);
                    break block18;
                }
                FileOpUtils.moveOrCopyAndDelete(destBackup, dest, fop, progress);
            }
            catch (IOException e) {
                progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
            }
        }
        fop.deleteFileOrFolder(destBackup);
    }

    private static void moveOrCopyAndDelete(File src, File dest, FileOp fop, ProgressIndicator progress) throws IOException {
        if (!fop.renameTo(src, dest)) {
            FileOpUtils.recursiveCopy(src, dest, true, fop, progress);
            fop.deleteFileOrFolder(src);
        }
    }

    private static File getTempDir(File orig, String suffix, FileOp fop) {
        File result2 = new File(orig + "." + suffix);
        int i2 = 1;
        while (fop.exists(result2)) {
            fop.deleteFileOrFolder(result2);
            if (!fop.exists(result2)) break;
            result2 = new File(result2.getPath() + "-" + i2++);
        }
        return result2;
    }

    public static File getNewTempDir(String base, FileOp fileOp) {
        for (int i2 = 1; i2 < 100; ++i2) {
            File folder = FileOpUtils.getTempDir(base, i2);
            if (fileOp.exists(folder)) continue;
            fileOp.mkdirs(folder);
            return folder;
        }
        return null;
    }

    @VisibleForTesting
    public static File getTempDir(String base, int i2) {
        File rootTempDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(rootTempDir, String.format("%1$s%2$02d", base, i2));
    }

    public static File append(File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static File append(String base, String ... segments) {
        return FileOpUtils.append(new File(base), segments);
    }

    public static String makeRelative(File baseDir, File toBeRelative, FileOp fop) throws IOException {
        return FileOpUtils.makeRelativeImpl(baseDir.getCanonicalPath(), toBeRelative.getCanonicalPath(), fop.isWindows(), File.separator);
    }

    @VisibleForTesting
    static String makeRelativeImpl(String path1, String path2, boolean isWindows, String dirSeparator) throws IOException {
        int start;
        if (isWindows) {
            char drive2;
            String p1 = path1;
            String p2 = path2;
            char drive1 = p1.length() >= 2 && p1.charAt(1) == ':' ? p1.charAt(0) : (char)'\u0000';
            char c = drive2 = p2.length() >= 2 && p2.charAt(1) == ':' ? p2.charAt(0) : (char)'\u0000';
            if (drive1 != drive2) {
                throw new IOException("makeRelative: incompatible drive letters");
            }
        }
        String[] segments1 = path1.split(Pattern.quote(dirSeparator));
        String[] segments2 = path2.split(Pattern.quote(dirSeparator));
        int len1 = segments1.length;
        int len2 = segments2.length;
        int len = Math.min(len1, len2);
        for (start = 0; start < len && (!isWindows || segments1[start].equalsIgnoreCase(segments2[start])) && (isWindows || segments1[start].equals(segments2[start])); ++start) {
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = start; i2 < len1; ++i2) {
            result2.append("..").append(dirSeparator);
        }
        while (start < len2) {
            result2.append(segments2[start]);
            if (++start >= len2) continue;
            result2.append(dirSeparator);
        }
        return result2.toString();
    }

    public static void retainTempDirs(Set<File> retain, String base, FileOp mFop) {
        for (int i2 = 0; i2 < 100; ++i2) {
            File dir = FileOpUtils.getTempDir(base, i2);
            if (!mFop.exists(dir) || retain.contains(dir)) continue;
            mFop.deleteFileOrFolder(dir);
        }
    }

    public static boolean deleteIfExists(File file, FileOp fop) {
        return !fop.exists(file) || fop.delete(file);
    }

    private FileOpUtils() {
    }
}

