/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.Channel;
import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.Repository;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.util.InstallerUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;

public class RemoteRepoLoaderImpl
implements RemoteRepoLoader {
    private static final int FETCH_PACKAGES_WAITING_ITERATION_SECONDS = 10;
    private static final String FETCH_PACKAGES_WAITING_MESSAGE = "Still waiting for package manifests to be fetched remotely.";
    private FallbackRemoteRepoLoader mFallback;
    private final Collection<RepositorySourceProvider> mSourceProviders;

    public RemoteRepoLoaderImpl(Collection<RepositorySourceProvider> sources, FallbackRemoteRepoLoader fallback) {
        this.mSourceProviders = sources;
        this.mFallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RemotePackage> fetchPackages(ProgressIndicator progress, Downloader downloader, SettingsController settings2) {
        HashMap<String, RemotePackage> result2 = Maps.newHashMap();
        ArrayList<RepositorySource> sources = Lists.newArrayList();
        double progressMax = 0.0;
        for (RepositorySourceProvider provider : this.mSourceProviders) {
            sources.addAll(provider.getSources(downloader, progress.createSubProgress(progressMax += 0.1 / (double)this.mSourceProviders.size()), false));
        }
        boolean wasIndeterminate = progress.isIndeterminate();
        progress.setIndeterminate(true);
        LoggingOnlyProgressIndicator loggingOnlyProgress = new LoggingOnlyProgressIndicator(progress);
        ArrayBlockingQueue downloadedRepoManifests = new ArrayBlockingQueue(sources.size());
        ExecutorService sourceThreadPool = Executors.newCachedThreadPool();
        int threadsSubmitted = 0;
        int resultsReceived = 0;
        try {
            for (RepositorySource source : sources) {
                if (!source.isEnabled()) continue;
                ++threadsSubmitted;
                sourceThreadPool.submit(() -> {
                    String errorMessage2 = null;
                    Exception error = null;
                    try {
                        InputStream repoStream = downloader.downloadAndStream(new URL(source.getUrl()), loggingOnlyProgress);
                        downloadedRepoManifests.put(new AbstractMap.SimpleImmutableEntry<RepositorySource, InputStream>(source, repoStream));
                    }
                    catch (MalformedURLException e) {
                        errorMessage2 = "Malformed URL";
                        error = e;
                    }
                    catch (IOException e) {
                        errorMessage2 = "IO exception while downloading manifest";
                        error = e;
                    }
                    catch (InterruptedException e) {
                        errorMessage2 = "Thread interrupted while enqueuing downloaded manifest";
                        error = e;
                    }
                    if (errorMessage2 != null) {
                        source.setFetchError(errorMessage2);
                        progress.logWarning(errorMessage2, error);
                    }
                });
            }
            sourceThreadPool.shutdown();
            progress.setIndeterminate(false);
            double progressIncrement = 0.9 / (double)(sources.size() * 2);
            while (!sourceThreadPool.isTerminated() && resultsReceived < threadsSubmitted || !downloadedRepoManifests.isEmpty()) {
                Map.Entry repoResult = null;
                try {
                    for (int waitedSeconds = 0; waitedSeconds < 10 && (repoResult = (Map.Entry)downloadedRepoManifests.poll(1L, TimeUnit.SECONDS)) == null && !sourceThreadPool.isTerminated(); ++waitedSeconds) {
                    }
                }
                catch (InterruptedException waitedSeconds) {
                    // empty catch block
                }
                if (repoResult == null) {
                    progress.logWarning(FETCH_PACKAGES_WAITING_MESSAGE);
                    continue;
                }
                ++resultsReceived;
                RepositorySource source = (RepositorySource)repoResult.getKey();
                InputStream repoStream = (InputStream)repoResult.getValue();
                this.processSource(source, repoStream, downloader, settings2, result2, progress, progressMax += progressIncrement);
                progress.setFraction(progressMax += progressIncrement);
            }
        }
        finally {
            RemoteRepoLoaderImpl.shutdownAndJoin(sourceThreadPool, progress);
            progress.setIndeterminate(wasIndeterminate);
        }
        return result2;
    }

    private void processSource(RepositorySource source, InputStream repoStream, Downloader downloader, SettingsController settings2, Map<String, RemotePackage> result2, ProgressIndicator progress, double progressMax) {
        final ArrayList<String> errors = Lists.newArrayList();
        ProgressIndicatorAdapter unmarshalProgress = new ProgressIndicatorAdapter(){

            @Override
            public void logWarning(String s2, Throwable e) {
                errors.add(s2);
                if (e != null) {
                    errors.add(e.toString());
                }
            }

            @Override
            public void logError(String s2, Throwable e) {
                errors.add(s2);
                if (e != null) {
                    errors.add(e.toString());
                }
            }
        };
        Repository repo = null;
        try {
            repo = (Repository)SchemaModuleUtil.unmarshal(repoStream, source.getPermittedModules(), true, unmarshalProgress);
        }
        catch (JAXBException e) {
            errors.add(e.toString());
        }
        Collection<RemotePackage> parsedPackages = null;
        boolean legacy = false;
        if (repo != null) {
            parsedPackages = repo.getRemotePackage();
            progress.setFraction(progressMax);
        } else if (this.mFallback != null) {
            parsedPackages = this.mFallback.parseLegacyXml(source, downloader, settings2, progress.createSubProgress(progressMax));
            legacy = true;
        }
        if (parsedPackages != null && !parsedPackages.isEmpty()) {
            for (RemotePackage remotePackage : parsedPackages) {
                Channel settingsChannel;
                String existingProtocol;
                URL existingUrl;
                int compare;
                RemotePackage existing = result2.get(remotePackage.getPath());
                if (existing != null && ((compare = existing.getVersion().compareTo(remotePackage.getVersion())) > 0 || compare == 0 && (legacy || (existingUrl = InstallerUtil.resolveCompleteArchiveUrl(existing, progress)) != null && (existingProtocol = existingUrl.getProtocol()).equals("file")))) continue;
                Channel channel = settingsChannel = settings2 == null || settings2.getChannel() == null ? Channel.DEFAULT : settings2.getChannel();
                if (remotePackage.getArchive() != null && remotePackage.getChannel().compareTo(settingsChannel) <= 0) {
                    remotePackage.setSource(source);
                    result2.put(remotePackage.getPath(), remotePackage);
                }
                source.setFetchError(null);
            }
        } else {
            progress.logWarning("Errors during XML parse:");
            for (String string : errors) {
                progress.logWarning(string);
            }
            if (this.mFallback != null) {
                progress.logWarning("Additionally, the fallback loader failed to parse the XML.");
            }
            source.setFetchError(errors.isEmpty() ? "unknown error" : (String)errors.get(0));
        }
    }

    private static void shutdownAndJoin(ExecutorService threadPool, ProgressIndicator progress) {
        if (threadPool.isTerminated()) {
            return;
        }
        threadPool.shutdown();
        try {
            while (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                progress.logWarning(FETCH_PACKAGES_WAITING_MESSAGE);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class LoggingOnlyProgressIndicator
    extends DelegatingProgressIndicator {
        LoggingOnlyProgressIndicator(ProgressIndicator progress) {
            super(progress);
        }

        @Override
        public void setFraction(double fraction) {
        }

        @Override
        public double getFraction() {
            return 0.0;
        }

        @Override
        public void setText(String text) {
        }

        @Override
        public void setSecondaryText(String text) {
        }

        @Override
        public ProgressIndicator createSubProgress(double max) {
            return this;
        }
    }
}

