/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.io.FileOp;
import com.google.common.base.Objects;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class License
implements Comparable<License> {
    public static final String LICENSE_DIR = "licenses";

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getValue();

    public abstract void setValue(String var1);

    public String getType() {
        return null;
    }

    public void setType(String type2) {
    }

    public String getLicenseHash() {
        return Hashing.sha1().hashBytes(this.getValue().getBytes(StandardCharsets.UTF_8)).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<License ref:").append(this.getId()).append(", text:").append(this.getValue()).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result2 = 31 * result2 + (this.getId() == null ? 0 : this.getId().hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        return Objects.equal(this.getValue(), other.getValue()) && Objects.equal(this.getId(), other.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAccepted(File repositoryRoot, FileOp fop) {
        if (repositoryRoot == null) {
            return false;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        if (!fop.exists(licenseFile)) {
            return false;
        }
        try (InputStreamReader licenseReader = new InputStreamReader(fop.newFileInputStream(licenseFile));){
            String hash;
            Iterator<String> iterator2 = CharStreams.readLines(licenseReader).iterator();
            do {
                if (!iterator2.hasNext()) return false;
            } while (!(hash = iterator2.next()).equals(this.getLicenseHash()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean setAccepted(File repositoryRoot, FileOp fop) {
        if (repositoryRoot == null) {
            return false;
        }
        if (this.checkAccepted(repositoryRoot, fop)) {
            return true;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        if (fop.exists(licenseDir) && !fop.isDirectory(licenseDir)) {
            return false;
        }
        if (!fop.exists(licenseDir) && !fop.mkdirs(licenseDir)) {
            return false;
        }
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        try (OutputStream os = fop.newFileOutputStream(licenseFile, true);){
            os.write(String.format("%n%s", this.getLicenseHash()).getBytes());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(License otherLicense) {
        return Comparator.comparing(License::getId).thenComparing(License::getValue).compare(this, otherLicense);
    }
}

