/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class Selector {
    public static final String SELECTOR_LOCAL_NAME = "selector";
    private final String mPackageName;

    public Selector(String packageName) {
        this.mPackageName = Preconditions.checkNotNull(packageName);
    }

    boolean appliesTo(XmlElement element) {
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        return packageName.isPresent() && this.mPackageName.equals(packageName.get().getValue());
    }

    boolean isResolvable(KeyResolver<String> resolver) {
        return resolver.resolve(this.mPackageName) != null;
    }

    public String toString() {
        return this.mPackageName;
    }
}

