/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderHandler {
    public static final String INSTRUMENTATION_RUNNER = "instrumentationRunner";
    public static final String PACKAGE_NAME = "packageName";
    public static final String APPLICATION_ID = "applicationId";
    public static final String FEATURE_NAME = "featureName";
    static final Pattern PATTERN = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}(.*)");

    public static boolean isPlaceHolder(String string) {
        return PATTERN.matcher(string).matches();
    }

    public static void visit(MergingReport.Record.Severity severity, XmlDocument xmlDocument, KeyBasedValueResolver<String> valueProvider, MergingReport.Builder mergingReportBuilder) {
        PlaceholderHandler.visit(severity, xmlDocument.getRootNode(), valueProvider, mergingReportBuilder);
    }

    private static void visit(MergingReport.Record.Severity severity, XmlElement xmlElement, KeyBasedValueResolver<String> valueProvider, MergingReport.Builder mergingReportBuilder) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            StringBuilder resultString = new StringBuilder();
            String inputString = xmlAttribute.getValue();
            Matcher matcher = PATTERN.matcher(inputString);
            if (!matcher.matches()) continue;
            int injected = 0;
            while (matcher.matches()) {
                String placeholderValue = valueProvider.getValue(matcher.group(2));
                resultString.append(matcher.group(1));
                if (placeholderValue == null) {
                    mergingReportBuilder.addMessage(xmlAttribute, severity, String.format("Attribute %1$s at %2$s requires a placeholder substitution but no value for <%3$s> is provided.", xmlAttribute.getId(), xmlAttribute.printPosition(), matcher.group(2)));
                    resultString.append("${");
                    resultString.append(matcher.group(2));
                    resultString.append("}");
                } else {
                    ++injected;
                    resultString.append(placeholderValue);
                }
                inputString = matcher.group(3);
                matcher = PATTERN.matcher(inputString);
            }
            resultString.append(inputString);
            xmlAttribute.getXml().setValue(resultString.toString());
            if (injected <= 0) continue;
            mergingReportBuilder.getActionRecorder().recordNodeAction(xmlElement, Actions.ActionType.INJECTED);
            for (int i2 = 0; i2 < injected; ++i2) {
                mergingReportBuilder.getActionRecorder().recordAttributeAction(xmlAttribute, SourcePosition.UNKNOWN, Actions.ActionType.INJECTED, null);
            }
        }
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            PlaceholderHandler.visit(severity, childElement, valueProvider, mergingReportBuilder);
        }
    }

    public static interface KeyBasedValueResolver<T> {
        public String getValue(T var1);
    }
}

