/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

public class Merger {
    public static void main(String[] args2) {
        try {
            System.exit(new Merger().process(args2));
        }
        catch (FileNotFoundException e) {
            System.exit(1);
        }
        System.exit(0);
    }

    public int process(String[] args2) throws FileNotFoundException {
        block26: {
            Iterator<String> arguments2 = Arrays.asList(args2).iterator();
            String mainManifest = null;
            StdLogger.Level logLevel = StdLogger.Level.INFO;
            ILogger logger = new StdLogger(logLevel);
            while (arguments2.hasNext()) {
                String selector = arguments2.next();
                if (!selector.startsWith("--")) {
                    logger.error(null, "Invalid parameter " + selector + ", expected a command switch", new Object[0]);
                    return 1;
                }
                if ("--usage".equals(selector)) {
                    Merger.usage();
                    return 0;
                }
                if ("--remove-tools-declarations".equals(selector)) continue;
                if (!arguments2.hasNext()) {
                    logger.error(null, "Command switch " + selector + " has no value associated", new Object[0]);
                    return 1;
                }
                String value = arguments2.next();
                if ("--main".equals(selector)) {
                    mainManifest = value;
                }
                if (!"--log".equals(selector)) continue;
                logLevel = StdLogger.Level.valueOf(value);
            }
            if (mainManifest == null) {
                System.err.println("--main command switch not provided.");
                return 1;
            }
            logger = this.createLogger(logLevel);
            File mainManifestFile = this.checkPath(mainManifest);
            ManifestMerger2.Invoker invoker = this.createInvoker(mainManifestFile, logger);
            arguments2 = Arrays.asList(args2).iterator();
            File outFile = null;
            while (arguments2.hasNext()) {
                File library;
                StringTokenizer stringTokenizer;
                String selector = arguments2.next();
                if ("--remove-tools-declarations".equals(selector)) {
                    invoker.withFeatures(ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS);
                    continue;
                }
                String value = arguments2.next();
                if (Strings.isNullOrEmpty(value)) {
                    logger.error(null, "Empty value for switch " + selector, new Object[0]);
                    return 1;
                }
                if ("--libs".equals(selector)) {
                    stringTokenizer = new StringTokenizer(value, File.pathSeparator);
                    while (stringTokenizer.hasMoreElements()) {
                        library = this.checkPath(stringTokenizer.nextToken());
                        invoker.addLibraryManifest(library);
                    }
                }
                if ("--overlays".equals(selector)) {
                    stringTokenizer = new StringTokenizer(value, File.pathSeparator);
                    while (stringTokenizer.hasMoreElements()) {
                        library = this.checkPath(stringTokenizer.nextToken());
                        invoker.addFlavorAndBuildTypeManifest(library);
                    }
                }
                if ("--property".equals(selector)) {
                    if (!value.contains("=")) {
                        logger.error(null, "Invalid property setting, should be NAME=VALUE format", new Object[0]);
                        return 1;
                    }
                    try {
                        ManifestSystemProperty manifestSystemProperty = ManifestSystemProperty.valueOf(value.substring(0, value.indexOf(61)).toUpperCase(Locale.ENGLISH));
                        invoker.setOverride(manifestSystemProperty, value.substring(value.indexOf(61) + 1));
                    }
                    catch (IllegalArgumentException e) {
                        logger.error(e, "Invalid property name " + value.substring(0, value.indexOf(61)) + ", allowed properties are : " + Joiner.on(',').join(ManifestSystemProperty.values()), new Object[0]);
                        return 1;
                    }
                }
                if ("--placeholder".equals(selector)) {
                    if (!value.contains("=")) {
                        logger.error(null, "Invalid placeholder setting, should be NAME=VALUE format", new Object[0]);
                        return 1;
                    }
                    invoker.setPlaceHolderValue(value.substring(0, value.indexOf(61)), value.substring(value.indexOf(61) + 1));
                }
                if (!"--out".equals(selector)) continue;
                outFile = new File(value);
            }
            try {
                MergingReport merge = invoker.merge();
                if (merge.getResult().isSuccess()) {
                    String mergedDocument = merge.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    if (mergedDocument == null) break block26;
                    if (outFile != null) {
                        try {
                            Files.asCharSink(outFile, Charsets.UTF_8, new FileWriteMode[0]).write(mergedDocument);
                            break block26;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    System.out.println(mergedDocument);
                    break block26;
                }
                for (MergingReport.Record record : merge.getLoggingRecords()) {
                    System.err.println(record);
                }
                return 1;
            }
            catch (ManifestMerger2.MergeFailureException e) {
                logger.error(e, "Exception while merging manifests", new Object[0]);
                return 1;
            }
        }
        return 0;
    }

    protected ManifestMerger2.Invoker createInvoker(File mainManifestFile, ILogger logger) {
        return ManifestMerger2.newMerger(mainManifestFile, logger, ManifestMerger2.MergeType.APPLICATION);
    }

    public static void usage() {
        System.out.println("Android Manifest Merger Tool Version 2\n");
        System.out.println("Usage:");
        System.out.println("Merger --main mainAndroidManifest.xml");
        System.out.println("\t--log [VERBOSE, INFO, WARNING, ERROR]");
        System.out.println("\t--libs [path separated list of lib's manifests]");
        System.out.println("\t--overlays [path separated list of overlay's manifests]");
        System.out.println("\t--property [" + Joiner.on(" | ").join(ManifestSystemProperty.values()) + "=value]");
        System.out.println("\t--placeholder [name=value]");
        System.out.println("\t--out [path of the output file]");
        System.out.println("\t--remove-tools-declarations");
    }

    @VisibleForTesting
    protected File checkPath(String path) throws FileNotFoundException {
        File file = new File(path);
        if (!file.exists()) {
            System.err.println(path + " does not exist");
            throw new FileNotFoundException(path);
        }
        return file;
    }

    @VisibleForTesting
    protected ILogger createLogger(StdLogger.Level level) {
        return new StdLogger(level);
    }
}

