/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.provision;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.provision.ProvisionRunner;
import com.android.instantapp.sdk.Metadata;
import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedList;
import java.util.List;

class ProvisionApksInstaller {
    private final LinkedList<Metadata.ApkInfo> myApkInfos = new LinkedList();

    ProvisionApksInstaller(List<Metadata.ApkInfo> apkInfos) {
        for (Metadata.ApkInfo apkInfo : apkInfos) {
            if (apkInfo.getPkgName().compareTo("com.google.android.instantapps.devman") == 0) {
                this.myApkInfos.addFirst(apkInfo);
                continue;
            }
            this.myApkInfos.addLast(apkInfo);
        }
    }

    private static long getVersion(IDevice device, String pkgName) throws ProvisionException {
        String output = ProvisionRunner.executeShellCommand(device, "dumpsys package " + pkgName, false, 500L);
        return ProvisionApksInstaller.parseOutput(output);
    }

    private static long parseOutput(String output) {
        int index = output.indexOf("versionCode");
        if (index == -1) {
            return 0L;
        }
        int begIndex = output.indexOf(61, index) + 1;
        int endIndex = output.indexOf(32, begIndex);
        int n = endIndex = endIndex == -1 ? output.indexOf(10, begIndex) : endIndex;
        if (endIndex == -1) {
            return 0L;
        }
        String versionCode = output.substring(begIndex, endIndex);
        return Long.parseLong(versionCode);
    }

    void installAll(IDevice device, ProvisionRunner.ProvisionState provisionState, ProvisionListener listener) throws ProvisionException {
        boolean firstGms = true;
        int currentInstalling = 0;
        for (Metadata.ApkInfo apkInfo : this.myApkInfos) {
            listener.setProgress(0.4 + (double)currentInstalling * 11.0 / (double)(20 * this.myApkInfos.size()));
            long installedVer = ProvisionApksInstaller.getVersion(device, apkInfo.getPkgName());
            long installingVer = apkInfo.getVersionCode();
            if (apkInfo.getPkgName().compareTo("com.google.android.instantapps.supervisor") == 0) {
                long sdkVersionCodeRange = 100000000L;
                installingVer = installingVer > 100000000L ? installingVer - 100000000L : installingVer;
                long l = installedVer = installedVer > 100000000L ? installedVer - 100000000L : installedVer;
            }
            if (currentInstalling > provisionState.lastInstalled && installedVer < installingVer) {
                try {
                    listener.printMessage("Installing package " + apkInfo.getPkgName());
                    listener.logMessage("Installing apk " + apkInfo.getApk(), null);
                    device.installPackage(apkInfo.getApk().getAbsolutePath(), true, "-d");
                    provisionState.lastInstalled = currentInstalling;
                }
                catch (InstallException e) {
                    if (firstGms && apkInfo.getPkgName().compareTo("com.google.android.gms") == 0) {
                        firstGms = false;
                    }
                    throw new ProvisionException(ProvisionException.ErrorType.INSTALL_FAILED, "APK " + apkInfo.getApk() + " could not be installed.", e);
                }
            }
            ++currentInstalling;
            if (!listener.isCancelled()) continue;
            throw new ProvisionException(ProvisionException.ErrorType.CANCELLED);
        }
    }

    @VisibleForTesting
    List<Metadata.ApkInfo> getApks() {
        return this.myApkInfos;
    }
}

