/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;

public class VdIcon
implements Icon,
Comparable<VdIcon> {
    private static final String ICON_PREFIX = "ic_";
    private static final String FILLED_PREFIX = "baseline_";
    private static final String OUTLINE_PREFIX = "outline_";
    private static final String ROUND_PREFIX = "round_";
    private static final String SHARP_PREFIX = "sharp_";
    private static final String TWO_TONE_PREFIX = "twotone_";
    private static final String ICON_SUFFIX = "_24.xml";
    public static final int LABEL_GAP = 10;
    private final VdTree mVdTree;
    private final String mName;
    private final URL mUrl;
    private boolean mDrawCheckerBoardBackground;
    private String mDisplayName;
    private boolean mShowName;
    private final Rectangle myRectangle = new Rectangle();
    private final int mWidth;
    private final int mHeight;
    private final Color mBackground;
    private static final Color CHECKER_COLOR = new Color(238, 238, 238);
    private static final byte[] COLOR_INVERSION_TABLE = new byte[256];

    public VdIcon(URL url) throws IOException {
        this(url, 0, 0);
    }

    public VdIcon(URL url, int width, int height) throws IOException {
        this.mVdTree = VdIcon.parseVdTree(url);
        this.mUrl = url;
        String fileName = url.getFile();
        this.mName = fileName.substring(fileName.lastIndexOf(47) + 1);
        if (width != 0 && height != 0) {
            this.mWidth = width;
            this.mHeight = height;
        } else {
            this.mWidth = (int)this.mVdTree.getPortWidth();
            this.mHeight = (int)this.mVdTree.getPortHeight();
        }
        this.mBackground = null;
    }

    public VdIcon(VdIcon icon, Color background) {
        this.mVdTree = icon.mVdTree;
        this.mUrl = icon.mUrl;
        this.mName = icon.mName;
        this.mWidth = icon.mWidth;
        this.mHeight = icon.mHeight;
        this.mBackground = background;
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            int begin = 0;
            if (this.mName.startsWith(ICON_PREFIX)) {
                begin = ICON_PREFIX.length();
            } else if (this.mName.startsWith(FILLED_PREFIX)) {
                begin = FILLED_PREFIX.length();
            } else if (this.mName.startsWith(OUTLINE_PREFIX)) {
                begin = OUTLINE_PREFIX.length();
            } else if (this.mName.startsWith(ROUND_PREFIX)) {
                begin = ROUND_PREFIX.length();
            } else if (this.mName.startsWith(SHARP_PREFIX)) {
                begin = SHARP_PREFIX.length();
            } else if (this.mName.startsWith(TWO_TONE_PREFIX)) {
                begin = TWO_TONE_PREFIX.length();
            }
            int end = this.mName.length();
            if (this.mName.endsWith(ICON_SUFFIX)) {
                end -= ICON_SUFFIX.length();
            } else if (this.mName.endsWith(".xml")) {
                end -= ".xml".length();
            }
            this.mDisplayName = this.mName.substring(begin, end).replace('_', ' ');
        }
        return this.mDisplayName;
    }

    public URL getURL() {
        return this.mUrl;
    }

    public BufferedImage renderIcon(int width, int height) {
        if (this.mVdTree == null) {
            return null;
        }
        if (width <= 0 || height <= 0) {
            width = Math.round(this.mVdTree.getBaseWidth());
            height = Math.round(this.mVdTree.getBaseHeight());
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage(width, height);
        this.mVdTree.drawIntoImage(image);
        return image;
    }

    private static VdTree parseVdTree(URL url) throws IOException {
        return VdParser.parse(url.openStream(), null);
    }

    public static void paintCheckeredBackground(Graphics g2, Color backgroundColor, Color checkeredColor, Shape clip, int cellSize) {
        Shape savedClip = g2.getClip();
        ((Graphics2D)g2).clip(clip);
        Rectangle rect = clip.getBounds();
        g2.setColor(backgroundColor);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(checkeredColor);
        int dy = 0;
        while (dy * cellSize < rect.height) {
            int dx = dy % 2;
            while (dx * cellSize < rect.width) {
                g2.fillRect(rect.x + dx * cellSize, rect.y + dy * cellSize, cellSize, cellSize);
                dx += 2;
            }
            ++dy;
        }
        g2.setClip(savedClip);
    }

    @Override
    public void paintIcon(Component c, Graphics gc, int x, int y) {
        Graphics2D g2 = (Graphics2D)gc;
        int width = c.getWidth();
        int height = c.getHeight();
        this.myRectangle.setBounds(0, 0, width, height);
        if (this.mBackground != null) {
            g2.setColor(this.mBackground);
            g2.fillRect(this.myRectangle.x, this.myRectangle.y, this.myRectangle.width, this.myRectangle.height);
        } else if (this.mDrawCheckerBoardBackground) {
            VdIcon.paintCheckeredBackground(g2, Color.LIGHT_GRAY, CHECKER_COLOR, this.myRectangle, 8);
        }
        if (this.mVdTree == null) {
            return;
        }
        if (this.mShowName) {
            FontMetrics fontMetrics = c.getFontMetrics(c.getFont());
            String displayName = this.getDisplayName();
            Rectangle2D bounds = fontMetrics.getStringBounds(displayName, g2);
            height = (int)((double)height - (bounds.getHeight() + 10.0));
            int textX = Math.max(0, (int)((double)width - bounds.getWidth()) / 2);
            int textY = height + 10;
            Shape prevClip = g2.getClip();
            g2.clip(this.myRectangle);
            g2.setColor(c.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (map2 != null) {
                g2.addRenderingHints(map2);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            g2.drawString(displayName, textX, textY);
            g2.setClip(prevClip);
        }
        int minSize = Math.min(width, height);
        BufferedImage image = AssetUtil.newArgbBufferedImage(minSize, minSize);
        this.mVdTree.drawIntoImage(image);
        image = VdIcon.adjustIconColor(c, image);
        Rectangle rect = new Rectangle(0, 0, width, height);
        AssetUtil.drawCenterInside(g2, image, rect);
    }

    public static BufferedImage adjustIconColor(Component component, BufferedImage image) {
        Color background = component.getBackground();
        if (background != null && background.getRed() < 128) {
            ByteLookupTable table = new ByteLookupTable(0, COLOR_INVERSION_TABLE);
            LookupOp invertFilter = new LookupOp(table, null);
            image = invertFilter.filter(image, null);
        }
        return image;
    }

    @Override
    public int getIconWidth() {
        return this.mWidth;
    }

    @Override
    public int getIconHeight() {
        return this.mHeight;
    }

    @Override
    public int compareTo(VdIcon other) {
        return this.mName.compareTo(other.mName);
    }

    public void enableCheckerBoardBackground(boolean enable) {
        this.mDrawCheckerBoardBackground = enable;
    }

    public void setShowName(boolean showName) {
        this.mShowName = showName;
    }

    static {
        for (int counter = 0; counter < 256; ++counter) {
            VdIcon.COLOR_INVERSION_TABLE[counter] = (byte)(3 * (255 - counter) / 4);
        }
    }
}

