/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.utils.XmlUtils;

public class PathBuilder {
    private StringBuilder mPathData = new StringBuilder();

    private static char encodeBoolean(boolean flag) {
        return flag ? (char)'1' : '0';
    }

    public PathBuilder absoluteMoveTo(double x, double y) {
        this.mPathData.append('M').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeMoveTo(double x, double y) {
        this.mPathData.append('m').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteLineTo(double x, double y) {
        this.mPathData.append('L').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeLineTo(double x, double y) {
        this.mPathData.append('l').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteVerticalTo(double v) {
        this.mPathData.append('V').append(XmlUtils.formatFloatValue(v));
        return this;
    }

    public PathBuilder relativeVerticalTo(double v) {
        this.mPathData.append('v').append(XmlUtils.formatFloatValue(v));
        return this;
    }

    public PathBuilder absoluteHorizontalTo(double h2) {
        this.mPathData.append('H').append(XmlUtils.formatFloatValue(h2));
        return this;
    }

    public PathBuilder relativeHorizontalTo(double h2) {
        this.mPathData.append('h').append(XmlUtils.formatFloatValue(h2));
        return this;
    }

    public PathBuilder absoluteCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.mPathData.append('C').append(XmlUtils.formatFloatValue(cp1x)).append(',').append(XmlUtils.formatFloatValue(cp1y)).append(',').append(XmlUtils.formatFloatValue(cp2x)).append(',').append(XmlUtils.formatFloatValue(cp2y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.mPathData.append('c').append(XmlUtils.formatFloatValue(cp1x)).append(',').append(XmlUtils.formatFloatValue(cp1y)).append(',').append(XmlUtils.formatFloatValue(cp2x)).append(',').append(XmlUtils.formatFloatValue(cp2y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteSmoothCurveTo(double cp2x, double cp2y, double x, double y) {
        this.mPathData.append('S').append(XmlUtils.formatFloatValue(cp2x)).append(',').append(XmlUtils.formatFloatValue(cp2y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeSmoothCurveTo(double cp2x, double cp2y, double x, double y) {
        this.mPathData.append('s').append(XmlUtils.formatFloatValue(cp2x)).append(',').append(XmlUtils.formatFloatValue(cp2y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteQuadraticCurveTo(double cp1x, double cp1y, double x, double y) {
        this.mPathData.append('Q').append(XmlUtils.formatFloatValue(cp1x)).append(',').append(XmlUtils.formatFloatValue(cp1y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeQuadraticCurveTo(double cp1x, double cp1y, double x, double y) {
        this.mPathData.append('q').append(XmlUtils.formatFloatValue(cp1x)).append(',').append(XmlUtils.formatFloatValue(cp1y)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteSmoothQuadraticCurveTo(double x, double y) {
        this.mPathData.append('T').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeSmoothQuadraticCurveTo(double x, double y) {
        this.mPathData.append('t').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteArcTo(double rx, double ry, boolean rotation, boolean largeArc, boolean sweep, double x, double y) {
        this.mPathData.append('A').append(XmlUtils.formatFloatValue(rx)).append(',').append(XmlUtils.formatFloatValue(ry)).append(',').append(PathBuilder.encodeBoolean(rotation)).append(',').append(PathBuilder.encodeBoolean(largeArc)).append(',').append(PathBuilder.encodeBoolean(sweep)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder relativeArcTo(double rx, double ry, boolean rotation, boolean largeArc, boolean sweep, double x, double y) {
        this.mPathData.append('a').append(XmlUtils.formatFloatValue(rx)).append(',').append(XmlUtils.formatFloatValue(ry)).append(',').append(PathBuilder.encodeBoolean(rotation)).append(',').append(PathBuilder.encodeBoolean(largeArc)).append(',').append(PathBuilder.encodeBoolean(sweep)).append(',').append(XmlUtils.formatFloatValue(x)).append(',').append(XmlUtils.formatFloatValue(y));
        return this;
    }

    public PathBuilder absoluteClose() {
        this.mPathData.append('Z');
        return this;
    }

    public PathBuilder relativeClose() {
        this.mPathData.append('z');
        return this;
    }

    public boolean isEmpty() {
        return this.mPathData.length() == 0;
    }

    public String toString() {
        return this.mPathData.toString();
    }
}

