/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;

class EllipseSolver {
    private float mMajorAxis;
    private float mMinorAxis;
    private float mRotationDegree;
    private boolean mDirectionChanged;

    public EllipseSolver(AffineTransform totalTransform, float currentX, float currentY, float rx, float ry, float xAxisRotation, float largeArcFlag, float sweepFlag, float destX, float destY) {
        if (rx == 0.0f || ry == 0.0f) {
            return;
        }
        boolean largeArc = largeArcFlag != 0.0f;
        boolean sweep = sweepFlag != 0.0f;
        Point2D.Double originalCenter = EllipseSolver.computeOriginalCenter(currentX, currentY, rx, ry, xAxisRotation, largeArc, sweep, destX, destY);
        Point2D.Double majorAxisPoint = new Point2D.Double(rx, 0.0);
        Point2D.Double minorAxisPoint = new Point2D.Double(0.0, ry);
        majorAxisPoint = EllipseSolver.rotatePoint2D(majorAxisPoint, xAxisRotation);
        minorAxisPoint = EllipseSolver.rotatePoint2D(minorAxisPoint, xAxisRotation);
        majorAxisPoint.x += originalCenter.x;
        majorAxisPoint.y += originalCenter.y;
        minorAxisPoint.x += originalCenter.x;
        minorAxisPoint.y += originalCenter.y;
        double middleRadians = 0.7853981633974483;
        double middleR = (double)(rx * ry) / Math.hypot((double)ry * Math.cos(middleRadians), (double)rx * Math.sin(middleRadians));
        Point2D.Double middlePoint = new Point2D.Double(middleR * Math.cos(middleRadians), middleR * Math.sin(middleRadians));
        middlePoint = EllipseSolver.rotatePoint2D(middlePoint, xAxisRotation);
        middlePoint.x += originalCenter.x;
        middlePoint.y += originalCenter.y;
        Point2D.Double mDstMiddlePoint = (Point2D.Double)totalTransform.transform(middlePoint, null);
        Point2D.Double mDstMajorAxisPoint = (Point2D.Double)totalTransform.transform(majorAxisPoint, null);
        Point2D.Double mDstMinorAxisPoint = (Point2D.Double)totalTransform.transform(minorAxisPoint, null);
        Point2D dstCenter = totalTransform.transform(originalCenter, null);
        double dstCenterX = dstCenter.getX();
        double dstCenterY = dstCenter.getY();
        double relativeDstMiddleX = mDstMiddlePoint.x - dstCenterX;
        double relativeDstMiddleY = mDstMiddlePoint.y - dstCenterY;
        double relativeDstMajorAxisPointX = mDstMajorAxisPoint.x - dstCenterX;
        double relativeDstMajorAxisPointY = mDstMajorAxisPoint.y - dstCenterY;
        double relativeDstMinorAxisPointX = mDstMinorAxisPoint.x - dstCenterX;
        double relativeDstMinorAxisPointY = mDstMinorAxisPoint.y - dstCenterY;
        this.mDirectionChanged = EllipseSolver.computeDirectionChange(middlePoint, majorAxisPoint, minorAxisPoint, mDstMiddlePoint, mDstMajorAxisPoint, mDstMinorAxisPoint);
        if (this.computeABThetaFromControlPoints(relativeDstMiddleX, relativeDstMiddleY, relativeDstMajorAxisPointX, relativeDstMajorAxisPointY, relativeDstMinorAxisPointX, relativeDstMinorAxisPointY)) {
            EllipseSolver.getLog().log(Level.WARNING, "Early return in the ellipse transformation computation!");
        }
    }

    private static Logger getLog() {
        return Logger.getLogger(EllipseSolver.class.getSimpleName());
    }

    private static boolean computeDirectionChange(Point2D.Double middlePoint, Point2D.Double majorAxisPoint, Point2D.Double minorAxisPoint, Point2D.Double dstMiddlePoint, Point2D.Double dstMajorAxisPoint, Point2D.Double dstMinorAxisPoint) {
        double dstCrossProduct;
        double srcCrossProduct = EllipseSolver.getCrossProduct(middlePoint, majorAxisPoint, minorAxisPoint);
        return srcCrossProduct * (dstCrossProduct = EllipseSolver.getCrossProduct(dstMiddlePoint, dstMajorAxisPoint, dstMinorAxisPoint)) < 0.0;
    }

    private static double getCrossProduct(Point2D.Double middlePoint, Point2D.Double majorAxisPoint, Point2D.Double minorAxisPoint) {
        double majorMinusMiddleX = majorAxisPoint.x - middlePoint.x;
        double majorMinusMiddleY = majorAxisPoint.y - middlePoint.y;
        double minorMinusMiddleX = minorAxisPoint.x - middlePoint.x;
        double minorMinusMiddleY = minorAxisPoint.y - middlePoint.y;
        return majorMinusMiddleX * minorMinusMiddleY - majorMinusMiddleY * minorMinusMiddleX;
    }

    private boolean computeABThetaFromControlPoints(double relMiddleX, double relMiddleY, double relativeMajorAxisPointX, double relativeMajorAxisPointY, double relativeMinorAxisPointX, double relativeMinorAxisPointY) {
        double m13 = relMiddleY * relMiddleY;
        double m22 = relativeMajorAxisPointX * relativeMajorAxisPointY;
        double m31 = relativeMinorAxisPointX * relativeMinorAxisPointX;
        double m12 = relMiddleX * relMiddleY;
        double m23 = relativeMajorAxisPointY * relativeMajorAxisPointY;
        double m21 = relativeMajorAxisPointX * relativeMajorAxisPointX;
        double m32 = relativeMinorAxisPointX * relativeMinorAxisPointY;
        double m11 = relMiddleX * relMiddleX;
        double m33 = relativeMinorAxisPointY * relativeMinorAxisPointY;
        double det = -(m13 * m22 * m31 - m12 * m23 * m31 - m13 * m21 * m32 + m11 * m23 * m32 + m12 * m21 * m33 - m11 * m22 * m33);
        if (det == 0.0) {
            return true;
        }
        double A2 = (-m13 * m22 + m12 * m23 + m13 * m32 - m23 * m32 - m12 * m33 + m22 * m33) / det;
        double B = (m13 * m21 - m11 * m23 - m13 * m31 + m23 * m31 + m11 * m33 - m21 * m33) / det;
        double C2 = (m12 * m21 - m11 * m22 - m12 * m31 + m22 * m31 + m11 * m32 - m21 * m32) / -det;
        if (A2 - C2 == 0.0) {
            this.mMajorAxis = this.mMinorAxis = (float)Math.hypot(relativeMajorAxisPointX, relativeMajorAxisPointY);
            this.mRotationDegree = 0.0f;
            return false;
        }
        double doubleThetaInRadians = Math.atan(B / (A2 - C2));
        double thetaInRadians = doubleThetaInRadians / 2.0;
        if (Math.sin(doubleThetaInRadians) == 0.0) {
            this.mMinorAxis = (float)Math.sqrt(1.0 / C2);
            this.mMajorAxis = (float)Math.sqrt(1.0 / A2);
            this.mRotationDegree = 0.0f;
            return false;
        }
        double bSqInv = (A2 + C2 + B / Math.sin(doubleThetaInRadians)) / 2.0;
        double aSqInv = A2 + C2 - bSqInv;
        if (bSqInv == 0.0 || aSqInv == 0.0) {
            return true;
        }
        this.mMinorAxis = (float)Math.sqrt(1.0 / bSqInv);
        this.mMajorAxis = (float)Math.sqrt(1.0 / aSqInv);
        this.mRotationDegree = (float)Math.toDegrees(1.5707963267948966 + thetaInRadians);
        return false;
    }

    private static Point2D.Double computeOriginalCenter(float x1, float y1, float rx, float ry, float phi, boolean largeArc, boolean sweep, float x2, float y2) {
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double xDelta = (x1 - x2) / 2.0f;
        double yDelta = (y1 - y2) / 2.0f;
        double tempX1 = cosPhi * xDelta + sinPhi * yDelta;
        double tempY1 = -sinPhi * xDelta + cosPhi * yDelta;
        double rxSq = rx * rx;
        double rySq = ry * ry;
        double tempX1Sq = tempX1 * tempX1;
        double tempY1Sq = tempY1 * tempY1;
        double tempCenterFactor = rxSq * rySq - rxSq * tempY1Sq - rySq * tempX1Sq;
        if ((tempCenterFactor /= rxSq * tempY1Sq + rySq * tempX1Sq) < 0.0) {
            tempCenterFactor = 0.0;
        }
        tempCenterFactor = Math.sqrt(tempCenterFactor);
        if (largeArc == sweep) {
            tempCenterFactor = -tempCenterFactor;
        }
        double tempCx = tempCenterFactor * (double)rx * tempY1 / (double)ry;
        double tempCy = -tempCenterFactor * (double)ry * tempX1 / (double)rx;
        double xCenter = (x1 + x2) / 2.0f;
        double yCenter = (y1 + y2) / 2.0f;
        return new Point2D.Double(cosPhi * tempCx - sinPhi * tempCy + xCenter, sinPhi * tempCx + cosPhi * tempCy + yCenter);
    }

    public float getMajorAxis() {
        return this.mMajorAxis;
    }

    public float getMinorAxis() {
        return this.mMinorAxis;
    }

    public float getRotationDegree() {
        return this.mRotationDegree;
    }

    public boolean getDirectionChanged() {
        return this.mDirectionChanged;
    }

    private static Point2D.Double rotatePoint2D(Point2D.Double inPoint, double radians2) {
        double cos = Math.cos(radians2);
        double sin = Math.sin(radians2);
        return new Point2D.Double(inPoint.x * cos - inPoint.y * sin, inPoint.x * sin + inPoint.y * cos);
    }
}

