/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.PartialRMergingException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolTableKt;
import com.android.ide.common.symbols.SymbolTableKt$sam$com_google_common_base_Supplier$0;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Interner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u0000 &2\u00020\u0001:\u0005%&'()B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0013\u001a\u00020\u0005J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/android/ide/common/symbols/SymbolTable;", "", "()V", "resourceTypes", "", "Lcom/android/resources/ResourceType;", "getResourceTypes", "()Ljava/util/Set;", "symbols", "Lcom/google/common/collect/ImmutableTable;", "", "Lcom/android/ide/common/symbols/Symbol;", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "tablePackage", "getTablePackage", "()Ljava/lang/String;", "containsSymbol", "", "type", "canonicalName", "filter", "table", "getSymbolByResourceType", "", "getSymbolByVisibility", "visibility", "Lcom/android/resources/ResourceVisibility;", "maybeGetStyleableParentSymbolForChild", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "start", "", "merge", "m", "rename", "withValuesFrom", "mainSymbolTable", "Builder", "Companion", "FastBuilder", "IllegalResourceVisibilityException", "SymbolTableImpl", "sdk-common"})
public abstract class SymbolTable {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getTablePackage();

    @NotNull
    public abstract ImmutableTable<ResourceType, String, Symbol> getSymbols();

    @NotNull
    public final SymbolTable filter(@NotNull SymbolTable table) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        ImmutableTable.Builder<ResourceType, String, Object> builder = ImmutableTable.builder();
        for (ResourceType resourceType : table.getSymbols().rowKeySet()) {
            ImmutableCollection symbols2;
            Intrinsics.checkExpressionValueIsNotNull((ImmutableCollection)((ImmutableMap)table.getSymbols().row((Object)resourceType)).values(), "table.symbols.row(resourceType).values");
            Intrinsics.checkExpressionValueIsNotNull((ImmutableSet)((ImmutableMap)this.getSymbols().row((Object)resourceType)).keySet(), "this.symbols.row(resourceType).keys");
            for (Symbol symbol : symbols2) {
                ImmutableSet filteringSymbolNames;
                if (!filteringSymbolNames.contains(symbol.getCanonicalName())) continue;
                builder.put(resourceType, symbol.getCanonicalName(), this.getSymbols().get((Object)resourceType, symbol.getCanonicalName()));
            }
        }
        String string = this.getTablePackage();
        ImmutableTable<ResourceType, String, Symbol> immutableTable = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(immutableTable, "builder.build()");
        return new SymbolTableImpl(string, immutableTable);
    }

    @NotNull
    public final SymbolTable merge(@NotNull SymbolTable m3) {
        Intrinsics.checkParameterIsNotNull(m3, "m");
        return Companion.merge(CollectionsKt.listOf(this, m3));
    }

    @NotNull
    public final SymbolTable rename(@NotNull String tablePackage) {
        Intrinsics.checkParameterIsNotNull(tablePackage, "tablePackage");
        return new SymbolTableImpl(tablePackage, this.getSymbols());
    }

    @NotNull
    public final List<Symbol> getSymbolByResourceType(@NotNull ResourceType type2) {
        ArrayList symbols2;
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        ArrayList arrayList = symbols2 = Lists.newArrayList(((ImmutableMap)this.getSymbols().row((Object)type2)).values());
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "symbols");
        List list = arrayList;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Symbol it = (Symbol)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getCanonicalName());
                it = (Symbol)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getCanonicalName();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
            }
        };
        CollectionsKt.sortWith(list, comparator);
        List<Symbol> list2 = Collections.unmodifiableList(symbols2);
        Intrinsics.checkExpressionValueIsNotNull(list2, "Collections.unmodifiableList(symbols)");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Symbol> getSymbolByVisibility(@NotNull ResourceVisibility visibility) {
        ArrayList symbols2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)visibility, "visibility");
        Collection collection = this.getSymbols().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "symbols.values()");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Symbol it = (Symbol)element$iv$iv;
            boolean bl = false;
            if (!(it.getResourceVisibility() == visibility)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ArrayList arrayList = symbols2 = Lists.newArrayList((List)destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "symbols");
        List list = arrayList;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Symbol it = (Symbol)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getCanonicalName());
                it = (Symbol)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getCanonicalName();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
            }
        };
        CollectionsKt.sortWith(list, comparator);
        List<Symbol> list2 = Collections.unmodifiableList(symbols2);
        Intrinsics.checkExpressionValueIsNotNull(list2, "Collections.unmodifiableList(symbols)");
        return list2;
    }

    public final boolean containsSymbol(@NotNull ResourceType type2, @NotNull String canonicalName) {
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        Intrinsics.checkParameterIsNotNull(canonicalName, "canonicalName");
        boolean found = this.getSymbols().contains((Object)type2, canonicalName);
        if (!found && type2 == ResourceType.STYLEABLE && StringsKt.contains$default((CharSequence)canonicalName, '_', false, 2, null)) {
            found = SymbolTable.maybeGetStyleableParentSymbolForChild$default(this, canonicalName, 0, 2, null) != null;
        }
        return found;
    }

    @Nullable
    public final Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild(@NotNull String canonicalName, int start) {
        Intrinsics.checkParameterIsNotNull(canonicalName, "canonicalName");
        Symbol.StyleableSymbol found = null;
        int index = StringsKt.indexOf$default((CharSequence)canonicalName, '_', start, false, 4, null);
        if (index > -1) {
            String string = canonicalName;
            int n = 0;
            int n2 = 0;
            String string2 = string.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String parentName = string2;
            if (this.getSymbols().contains((Object)ResourceType.STYLEABLE, parentName)) {
                Symbol.StyleableSymbol styleableSymbol;
                String it;
                Object element$iv;
                boolean bl;
                int $i$f$any;
                Object $this$any$iv;
                Symbol parent;
                String childName;
                CharSequence charSequence;
                boolean bl2;
                block17: {
                    String string3 = canonicalName;
                    n2 = index + 1;
                    int n3 = canonicalName.length();
                    bl2 = false;
                    String string4 = string3.substring(n2, n3);
                    Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    charSequence = string4;
                    childName = charSequence;
                    parent = (Symbol)this.getSymbols().get((Object)ResourceType.STYLEABLE, parentName);
                    $this$any$iv = parent.getChildren();
                    $i$f$any = 0;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it, childName)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Symbol symbol = parent;
                    if (symbol == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                    }
                    styleableSymbol = (Symbol.StyleableSymbol)symbol;
                } else {
                    styleableSymbol = found = null;
                }
                if (found == null && StringsKt.startsWith$default(childName, "android_", false, 2, null)) {
                    Symbol.StyleableSymbol styleableSymbol2;
                    boolean bl4;
                    block18: {
                        $this$any$iv = childName;
                        $i$f$any = "android_".length();
                        charSequence = new StringBuilder().append("android:");
                        bl2 = false;
                        Object object = $this$any$iv;
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = ((String)object).substring($i$f$any);
                        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).substring(startIndex)");
                        String string6 = string5;
                        childName = ((StringBuilder)charSequence).append(string6).toString();
                        $this$any$iv = parent.getChildren();
                        $i$f$any = 0;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            Iterator iterator3 = $this$any$iv.iterator();
                            while (iterator3.hasNext()) {
                                element$iv = iterator3.next();
                                it = (String)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual(it, childName)) continue;
                                bl4 = true;
                                break block18;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        Symbol symbol = parent;
                        if (symbol == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                        }
                        styleableSymbol2 = (Symbol.StyleableSymbol)symbol;
                    } else {
                        styleableSymbol2 = found = null;
                    }
                }
            }
            if (found == null) {
                found = this.maybeGetStyleableParentSymbolForChild(canonicalName, index + 1);
            }
        }
        return found;
    }

    public static /* synthetic */ Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild$default(SymbolTable symbolTable, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maybeGetStyleableParentSymbolForChild");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return symbolTable.maybeGetStyleableParentSymbolForChild(string, n);
    }

    @NotNull
    public final SymbolTable withValuesFrom(@NotNull SymbolTable mainSymbolTable) {
        Intrinsics.checkParameterIsNotNull(mainSymbolTable, "mainSymbolTable");
        return mainSymbolTable.filter(this).rename(this.getTablePackage());
    }

    @NotNull
    public final Set<ResourceType> getResourceTypes() {
        Set set = this.getSymbols().rowKeySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "symbols.rowKeySet()");
        return set;
    }

    protected SymbolTable() {
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
        return Companion.merge(tables);
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
        return Companion.mergePartialTables(tables, packageName);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$SymbolTableImpl;", "Lcom/android/ide/common/symbols/SymbolTable;", "tablePackage", "", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "Lcom/android/ide/common/symbols/Symbol;", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableTable;)V", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "getTablePackage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "sdk-common"})
    private static final class SymbolTableImpl
    extends SymbolTable {
        @NotNull
        private final String tablePackage;
        @NotNull
        private final ImmutableTable<ResourceType, String, Symbol> symbols;

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("SymbolTable (").append(this.getTablePackage()).append(')').append("\n  ");
            Collection collection = this.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "symbols.values()");
            return stringBuilder.append(CollectionsKt.joinToString$default(collection, "\n  ", null, null, 0, null, null, 62, null)).toString();
        }

        @Override
        @NotNull
        public String getTablePackage() {
            return this.tablePackage;
        }

        @Override
        @NotNull
        public ImmutableTable<ResourceType, String, Symbol> getSymbols() {
            return this.symbols;
        }

        public SymbolTableImpl(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull(tablePackage, "tablePackage");
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            this.tablePackage = tablePackage;
            this.symbols = symbols2;
        }

        @NotNull
        public final String component1() {
            return this.getTablePackage();
        }

        @NotNull
        public final ImmutableTable<ResourceType, String, Symbol> component2() {
            return this.getSymbols();
        }

        @NotNull
        public final SymbolTableImpl copy(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull(tablePackage, "tablePackage");
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            return new SymbolTableImpl(tablePackage, symbols2);
        }

        public static /* synthetic */ SymbolTableImpl copy$default(SymbolTableImpl symbolTableImpl, String string, ImmutableTable immutableTable, int n, Object object) {
            if ((n & 1) != 0) {
                string = symbolTableImpl.getTablePackage();
            }
            if ((n & 2) != 0) {
                immutableTable = symbolTableImpl.getSymbols();
            }
            return symbolTableImpl.copy(string, immutableTable);
        }

        public int hashCode() {
            String string = this.getTablePackage();
            ImmutableTable<ResourceType, String, Symbol> immutableTable = this.getSymbols();
            return (string != null ? string.hashCode() : 0) * 31 + (immutableTable != null ? ((Object)immutableTable).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SymbolTableImpl)) break block3;
                    SymbolTableImpl symbolTableImpl = (SymbolTableImpl)object;
                    if (!Intrinsics.areEqual(this.getTablePackage(), symbolTableImpl.getTablePackage()) || !Intrinsics.areEqual(this.getSymbols(), symbolTableImpl.getSymbols())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0015\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0010J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Builder;", "", "()V", "symbols", "Lcom/google/common/collect/Table;", "Lcom/android/resources/ResourceType;", "", "Lcom/android/ide/common/symbols/Symbol;", "tablePackage", "add", "symbol", "addAll", "", "addAllIfNotExist", "addFromPartial", "table", "Lcom/android/ide/common/symbols/SymbolTable;", "addFromPartial$sdk_common", "build", "contains", "", "resourceType", "canonicalName", "get", "isEmpty", "remove", "sdk-common"})
    public static final class Builder {
        private String tablePackage = "";
        private final Table<ResourceType, String, Symbol> symbols;

        @NotNull
        public final Builder add(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull(symbol, "symbol");
            if (this.symbols.contains((Object)symbol.getResourceType(), symbol.getCanonicalName())) {
                throw (Throwable)new IllegalArgumentException("Duplicate symbol in table with resource type '" + (Object)((Object)symbol.getResourceType()) + "' " + "and symbol name '" + symbol.getCanonicalName() + '\'');
            }
            this.symbols.put(symbol.getResourceType(), symbol.getCanonicalName(), symbol);
            return this;
        }

        @NotNull
        public final Builder addAll(@NotNull Collection<? extends Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            Iterable $this$forEach$iv = symbols2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addAllIfNotExist(@NotNull Collection<? extends Symbol> symbols2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            Iterable $this$filter$iv = symbols2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Symbol it = (Symbol)element$iv$iv;
                boolean bl = false;
                if (!(!this.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
            return this;
        }

        @NotNull
        public final Builder addFromPartial$sdk_common(@NotNull SymbolTable table) {
            Intrinsics.checkParameterIsNotNull(table, "table");
            Collection collection = table.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "table.symbols.values()");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                if (!this.symbols.contains((Object)it.getResourceType(), it.getCanonicalName())) {
                    this.symbols.put(it.getResourceType(), it.getCanonicalName(), it);
                    continue;
                }
                Symbol existing = this.symbols.get((Object)it.getResourceType(), it.getCanonicalName());
                if (existing.getResourceVisibility() != it.getResourceVisibility() && existing.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY && it.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY) {
                    throw (Throwable)new IllegalResourceVisibilityException("Symbol with resource type " + (Object)((Object)it.getResourceType()) + " and name " + it.getCanonicalName() + " defined both as " + (Object)((Object)it.getResourceVisibility()) + " and " + (Object)((Object)existing.getResourceVisibility()) + '.');
                }
                if (it.getResourceType() == ResourceType.STYLEABLE) {
                    Symbol symbol = it;
                    if (symbol == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                    }
                    Symbol.StyleableSymbol cfr_ignored_0 = (Symbol.StyleableSymbol)symbol;
                    Symbol symbol2 = existing;
                    if (symbol2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                    }
                    Symbol.StyleableSymbol cfr_ignored_1 = (Symbol.StyleableSymbol)symbol2;
                    boolean bl2 = false;
                    ImmutableList children = ImmutableList.copyOf(CollectionsKt.sorted(SetsKt.plus(SetsKt.plus((Set)new LinkedHashSet(), (Iterable)it.getChildren()), (Iterable)existing.getChildren())));
                    ResourceVisibility visibility = ResourceVisibility.max(it.getResourceVisibility(), existing.getResourceVisibility());
                    this.symbols.remove((Object)existing.getResourceType(), existing.getCanonicalName());
                    ResourceType resourceType = it.getResourceType();
                    String string = it.getCanonicalName();
                    String string2 = it.getCanonicalName();
                    ImmutableList immutableList = ImmutableList.of();
                    Intrinsics.checkExpressionValueIsNotNull(immutableList, "ImmutableList.of()");
                    ImmutableList immutableList2 = children;
                    Intrinsics.checkExpressionValueIsNotNull(immutableList2, "children");
                    ResourceVisibility resourceVisibility = visibility;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceVisibility, "visibility");
                    this.symbols.put(resourceType, string, Symbol.Companion.styleableSymbol$default(Symbol.Companion, string2, immutableList, immutableList2, resourceVisibility, null, 16, null));
                    continue;
                }
                if (it.getResourceVisibility().compareTo((Enum)existing.getResourceVisibility()) <= 0) continue;
                this.symbols.remove((Object)existing.getResourceType(), existing.getCanonicalName());
                this.symbols.put(it.getResourceType(), it.getCanonicalName(), it);
            }
            return this;
        }

        @NotNull
        public final Builder tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkParameterIsNotNull(tablePackage, "tablePackage");
            SymbolTableKt.access$verifyTablePackage(tablePackage);
            this.tablePackage = tablePackage;
            return this;
        }

        public final boolean contains(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull(symbol, "symbol");
            return this.contains(symbol.getResourceType(), symbol.getCanonicalName());
        }

        public final boolean contains(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, "resourceType");
            Intrinsics.checkParameterIsNotNull(canonicalName, "canonicalName");
            return this.symbols.contains((Object)resourceType, canonicalName);
        }

        @Nullable
        public final Symbol get(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull(symbol, "symbol");
            return this.symbols.get((Object)symbol.getResourceType(), symbol.getCanonicalName());
        }

        @Nullable
        public final Symbol remove(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, "resourceType");
            Intrinsics.checkParameterIsNotNull(canonicalName, "canonicalName");
            return this.symbols.remove((Object)resourceType, canonicalName);
        }

        public final boolean isEmpty() {
            return this.symbols.isEmpty();
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable<ResourceType, String, Symbol> immutableTable = ImmutableTable.copyOf(this.symbols);
            Intrinsics.checkExpressionValueIsNotNull(immutableTable, "ImmutableTable.copyOf(symbols)");
            return new SymbolTableImpl(this.tablePackage, immutableTable);
        }

        public Builder() {
            Map map2 = Maps.newEnumMap(ResourceType.class);
            Object object = symbols.1.INSTANCE;
            if (object != null) {
                Function0 function0 = object;
                object = new SymbolTableKt$sam$com_google_common_base_Supplier$0(function0);
            }
            Table table = Tables.newCustomTable(map2, (Supplier)object);
            Intrinsics.checkExpressionValueIsNotNull(table, "Tables.newCustomTable(Ma\u2026::class.java), ::HashMap)");
            this.symbols = table;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0014\u0010\u000e\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\n\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$FastBuilder;", "", "symbolInterner", "Lcom/google/common/collect/Interner;", "Lcom/android/ide/common/symbols/Symbol;", "(Lcom/google/common/collect/Interner;)V", "symbols", "Lcom/google/common/collect/ImmutableTable$Builder;", "Lcom/android/resources/ResourceType;", "", "tablePackage", "add", "", "symbol", "addAll", "", "build", "Lcom/android/ide/common/symbols/SymbolTable;", "sdk-common"})
    public static final class FastBuilder {
        private String tablePackage;
        private final ImmutableTable.Builder<ResourceType, String, Symbol> symbols;
        private final Interner<Symbol> symbolInterner;

        public final void add(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull(symbol, "symbol");
            this.symbols.put(symbol.getResourceType(), symbol.getCanonicalName(), this.symbolInterner.intern(symbol));
        }

        public final void addAll(@NotNull Collection<? extends Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            Iterable $this$forEach$iv = symbols2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
        }

        public final void tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkParameterIsNotNull(tablePackage, "tablePackage");
            SymbolTableKt.access$verifyTablePackage(tablePackage);
            this.tablePackage = tablePackage;
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable<ResourceType, String, Symbol> immutableTable = this.symbols.build();
            Intrinsics.checkExpressionValueIsNotNull(immutableTable, "symbols.build()");
            return new SymbolTableImpl(this.tablePackage, immutableTable);
        }

        public FastBuilder(@NotNull Interner<Symbol> symbolInterner) {
            Intrinsics.checkParameterIsNotNull(symbolInterner, "symbolInterner");
            this.symbolInterner = symbolInterner;
            this.tablePackage = "";
            ImmutableTable.Builder builder = ImmutableTable.builder();
            Intrinsics.checkExpressionValueIsNotNull(builder, "ImmutableTable.builder()");
            this.symbols = builder;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$IllegalResourceVisibilityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "description", "", "(Ljava/lang/String;)V", "sdk-common"})
    public static final class IllegalResourceVisibilityException
    extends Exception {
        public IllegalResourceVisibilityException(@NotNull String description2) {
            Intrinsics.checkParameterIsNotNull(description2, "description");
            super(description2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0007J\u001e\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Companion;", "", "()V", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "merge", "Lcom/android/ide/common/symbols/SymbolTable;", "tables", "", "mergePartialTables", "Ljava/io/File;", "packageName", "", "sdk-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
            Intrinsics.checkParameterIsNotNull(tables, "tables");
            if (tables.size() == 1) {
                return CollectionsKt.first(tables);
            }
            ImmutableTable.Builder<ResourceType, String, Symbol> builder = ImmutableTable.builder();
            HashSet<String> present = new HashSet<String>();
            for (ResourceType resourceType : ResourceType.values()) {
                present.clear();
                for (SymbolTable symbolTable : tables) {
                    Map tableSymbolMap = symbolTable.getSymbols().row((Object)resourceType);
                    if (tableSymbolMap == null || ((ImmutableMap)tableSymbolMap).isEmpty()) continue;
                    for (Symbol s2 : (ImmutableCollection)((ImmutableMap)tableSymbolMap).values()) {
                        String canonicalName = s2.getCanonicalName();
                        if (present.contains(canonicalName)) continue;
                        present.add(canonicalName);
                        builder.put(resourceType, canonicalName, s2);
                    }
                }
            }
            String packageName = tables.isEmpty() ? "" : tables.get(0).getTablePackage();
            ImmutableTable<ResourceType, String, Symbol> immutableTable = builder.build();
            Intrinsics.checkExpressionValueIsNotNull(immutableTable, "builder.build()");
            return new SymbolTableImpl(packageName, immutableTable);
        }

        @JvmStatic
        @NotNull
        public final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
            Intrinsics.checkParameterIsNotNull(tables, "tables");
            Intrinsics.checkParameterIsNotNull(packageName, "packageName");
            SymbolIo symbolIo = new SymbolIo();
            Builder builder = Companion.builder();
            builder.tablePackage(packageName);
            HashSet<String> visitedFiles = new HashSet<String>();
            try {
                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)tables);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
                    if (StringsKt.startsWith$default(string, "layout", false, 2, null)) {
                        if (visitedFiles.contains(it.getName())) continue;
                        visitedFiles.add(it.getName());
                        SymbolTable symbolTable = symbolIo.readFromPartialRFile(it, null);
                        Intrinsics.checkExpressionValueIsNotNull(symbolTable, "symbolIo.readFromPartialRFile(it, null)");
                        builder.addFromPartial$sdk_common(symbolTable);
                        continue;
                    }
                    SymbolTable symbolTable = symbolIo.readFromPartialRFile(it, null);
                    Intrinsics.checkExpressionValueIsNotNull(symbolTable, "symbolIo.readFromPartialRFile(it, null)");
                    builder.addFromPartial$sdk_common(symbolTable);
                }
            }
            catch (Exception e) {
                throw (Throwable)new PartialRMergingException("An error occurred during merging of the partial R files", e);
            }
            return builder.build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

