/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RGeneration {
    private RGeneration() {
    }

    public static void generateRForLibraries(SymbolTable main2, Collection<SymbolTable> libraries, File out, boolean finalIds) {
        Preconditions.checkArgument(out.isDirectory(), "!out.iDirectory");
        for (SymbolTable symbolTable : RGeneration.generateLibrarySymbolTablesToWrite(main2, main2, libraries)) {
            SymbolIo.exportToJava(symbolTable, out, finalIds);
        }
    }

    public static List<SymbolTable> generateAllSymbolTablesToWrite(SymbolTable allSymbols, SymbolTable main2, Collection<SymbolTable> dependencies) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(main2)).addAll(RGeneration.generateLibrarySymbolTablesToWrite(main2, allSymbols, dependencies))).build();
    }

    private static List<SymbolTable> generateLibrarySymbolTablesToWrite(SymbolTable main2, SymbolTable allSymbols, Collection<SymbolTable> dependencies) {
        HashMap<String, SymbolTable> toWrite = new HashMap<String, SymbolTable>();
        for (SymbolTable st : dependencies) {
            if (st.getTablePackage().equals(main2.getTablePackage())) continue;
            SymbolTable existing = (SymbolTable)toWrite.get(st.getTablePackage());
            if (existing != null) {
                toWrite.put(st.getTablePackage(), existing.merge(st));
                continue;
            }
            toWrite.put(st.getTablePackage(), st);
        }
        for (String pkg : new HashSet(toWrite.keySet())) {
            SymbolTable st = ((SymbolTable)toWrite.get(pkg)).withValuesFrom(allSymbols);
            toWrite.put(pkg, st);
        }
        ArrayList toWriteList = new ArrayList(toWrite.values());
        toWriteList.sort(Comparator.comparing(SymbolTable::getTablePackage));
        return Collections.unmodifiableList(toWriteList);
    }
}

