/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceUsageModel {
    private static final int TYPICAL_RESOURCE_COUNT = 200;
    private final List<Resource> mResources = Lists.newArrayListWithExpectedSize(200);
    private final Map<ResourceType, Map<String, Resource>> mTypeToName = Maps.newEnumMap(ResourceType.class);
    private final Map<Integer, Resource> mValueToResource = Maps.newHashMapWithExpectedSize(200);
    private Set<String> mWhitelistedResources = Sets.newHashSet();
    private int nextInlinedResourceSuffix;
    private static final String ANDROID_RES = "android_res/";
    private static final int RESOURCE_DECLARED = 2;
    private static final int RESOURCE_PUBLIC = 4;
    private static final int RESOURCE_KEEP = 8;
    private static final int RESOURCE_DISCARD = 16;
    private static final int RESOURCE_REACHABLE = 32;
    private List<String> mKeepAttributes;
    private List<String> mDiscardAttributes;
    private boolean mSafeMode = true;
    private static final String ANALYTICS_FILE = "analytics.xml";
    private static byte[] sAndroidResBytes;

    public static String getResourceFieldName(Element element) {
        return ResourcesUtil.resourceNameToFieldName(element.getAttribute("name"));
    }

    public Resource getResource(Element element) {
        return this.getResource(element, false);
    }

    public Resource getResource(Element element, boolean declare) {
        ResourceType type2 = ResourceType.fromXmlTag(element);
        if (type2 != null) {
            String name = ResourceUsageModel.getResourceFieldName(element);
            Resource resource = this.getResource(type2, name);
            if (resource == null && declare) {
                resource = this.addResource(type2, name, null);
                resource.setDeclared(true);
            }
            return resource;
        }
        return null;
    }

    public Resource getResource(Integer value) {
        return this.mValueToResource.get(value);
    }

    public Resource getResource(ResourceType type2, String name) {
        Map<String, Resource> nameMap = this.mTypeToName.get((Object)type2);
        if (nameMap != null) {
            return nameMap.get(ResourcesUtil.resourceNameToFieldName(name));
        }
        return null;
    }

    public Resource getResourceFromUrl(String possibleUrlReference) {
        ResourceUrl url = ResourceUrl.parse(possibleUrlReference);
        if (url != null && !url.isFramework()) {
            return this.addResource(url.type, ResourcesUtil.resourceNameToFieldName(url.name), null);
        }
        return null;
    }

    public Resource getResourceFromFilePath(String url) {
        List<ResourceType> types;
        String folderName;
        ResourceFolderType folderType;
        int slash;
        int nameSlash = url.lastIndexOf(47);
        if (nameSlash == -1) {
            return null;
        }
        int androidRes = url.indexOf(ANDROID_RES);
        if (androidRes != -1 && (slash = url.indexOf(47, androidRes += ANDROID_RES.length())) != -1 && (folderType = ResourceFolderType.getFolderType(folderName = url.substring(androidRes, slash))) != null && !(types = FolderTypeRelationship.getRelatedResourceTypes(folderType)).isEmpty()) {
            int nameBegin;
            ResourceType type2 = types.get(0);
            int dot = url.indexOf(46, nameBegin = slash + 1);
            String name = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type2, name);
        }
        int typeSlash = url.lastIndexOf(47, nameSlash - 1);
        ResourceType type3 = ResourceType.fromXmlValue(url.substring(typeSlash + 1, nameSlash));
        if (type3 != null) {
            int nameBegin;
            int dot = url.indexOf(46, nameBegin = nameSlash + 1);
            String name = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type3, name);
        }
        return null;
    }

    public static boolean markReachable(Resource resource) {
        if (resource != null) {
            boolean wasReachable = resource.isReachable();
            resource.setReachable(true);
            return !wasReachable;
        }
        return false;
    }

    private static void markUnreachable(Resource resource) {
        if (resource != null) {
            resource.setReachable(false);
        }
    }

    public void recordManifestUsages(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Attr attr = (Attr)attributes.item(i2);
                ResourceUsageModel.markReachable(this.getResourceFromUrl(attr.getValue()));
            }
        } else if (nodeType == 3) {
            String text = node.getNodeValue().trim();
            ResourceUsageModel.markReachable(this.getResourceFromUrl(text));
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i3 = 0; i3 < n; ++i3) {
            Node child = children.item(i3);
            this.recordManifestUsages(child);
        }
    }

    public List<Resource> findUnused() {
        return this.findUnused(this.mResources);
    }

    public String dumpWhitelistedResources() {
        return Joiner.on(",").join(this.mWhitelistedResources.stream().sorted().collect(Collectors.toList()));
    }

    public String dumpConfig() {
        StringBuilder sb = new StringBuilder();
        this.mResources.sort((resource1, resource2) -> {
            int delta = resource1.type.compareTo(resource2.type);
            if (delta != 0) {
                return delta;
            }
            return resource1.name.compareTo(resource2.name);
        });
        for (Resource resource : this.mResources) {
            sb.append((Object)resource.type);
            sb.append('/');
            sb.append(resource.name);
            sb.append("#");
            ArrayList<ResourceActions> actions = new ArrayList<ResourceActions>(2);
            if (!resource.isReachable()) {
                actions.add(ResourceActions.REMOVE);
            }
            if (this.mWhitelistedResources.contains(resource.name)) {
                actions.add(ResourceActions.NO_OBFUSCATE);
            }
            sb.append(Joiner.on(",").join(actions));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String dumpReferences() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("Resource Reference Graph:\n");
        for (Resource resource : this.mResources) {
            if (resource.references == null) continue;
            sb.append(resource).append(" => ").append(resource.references).append('\n');
        }
        return sb.toString();
    }

    public String dumpResourceModel() {
        StringBuilder sb = new StringBuilder(1000);
        this.mResources.sort((resource1, resource2) -> {
            int delta = resource1.type.compareTo(resource2.type);
            if (delta != 0) {
                return delta;
            }
            return resource1.name.compareTo(resource2.name);
        });
        for (Resource resource : this.mResources) {
            sb.append(resource.getUrl()).append(" : reachable=").append(resource.isReachable());
            sb.append("\n");
            if (resource.references == null) continue;
            for (Resource referenced : resource.references) {
                sb.append("    ");
                sb.append(referenced.getUrl());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public List<Resource> findUnused(List<Resource> resources) {
        List<Resource> roots = this.findRoots(resources);
        IdentityHashMap<Resource, Boolean> seen = new IdentityHashMap<Resource, Boolean>(resources.size());
        for (Resource root : roots) {
            ResourceUsageModel.visit(root, seen);
        }
        ArrayList<Resource> unused = Lists.newArrayListWithExpectedSize(resources.size());
        for (Resource resource : resources) {
            if (resource.isReachable() || resource.type == ResourceType.ATTR || resource.type == ResourceType.STYLEABLE || SdkUtils.isServiceKey(resource.name)) continue;
            unused.add(resource);
        }
        return unused;
    }

    protected List<Resource> findRoots(List<Resource> resources) {
        ArrayList<Resource> roots = Lists.newArrayList();
        for (Resource resource : resources) {
            if (!resource.isReachable() && !resource.isKeep()) continue;
            roots.add(resource);
        }
        return roots;
    }

    private static void visit(Resource root, Map<Resource, Boolean> seen) {
        if (seen.containsKey(root)) {
            return;
        }
        seen.put(root, Boolean.TRUE);
        root.setReachable(true);
        if (root.references != null) {
            for (Resource referenced : root.references) {
                ResourceUsageModel.visit(referenced, seen);
            }
        }
    }

    public Resource addDeclaredResource(ResourceType type2, String name, String value, boolean declared) {
        Resource resource = this.addResource(type2, name, value);
        if (declared) {
            resource.setDeclared(true);
        }
        return resource;
    }

    public boolean addResourceToWhitelist(Resource resource) {
        if (resource == null || Strings.isNullOrEmpty(resource.name)) {
            return false;
        }
        return this.mWhitelistedResources.add(resource.name);
    }

    public Resource addResource(ResourceType type2, String name, String value) {
        return this.addResource(type2, name, value != null ? Integer.decode(value) : -1);
    }

    public Resource addResource(ResourceType type2, String name, int realValue) {
        Resource resource = this.getResource(type2, name);
        if (resource != null) {
            if (realValue != -1) {
                if (resource.value == -1) {
                    resource.value = realValue;
                } else assert (realValue == resource.value);
            }
            return resource;
        }
        resource = this.createResource(type2, name, realValue);
        this.mResources.add(resource);
        if (realValue != -1) {
            this.mValueToResource.put(realValue, resource);
        }
        Map nameMap = this.mTypeToName.computeIfAbsent(type2, k -> Maps.newHashMapWithExpectedSize(30));
        nameMap.put(ResourcesUtil.resourceNameToFieldName(name), resource);
        return resource;
    }

    protected Resource createResource(ResourceType type2, String name, int realValue) {
        return new Resource(type2, name, realValue);
    }

    private void processKeepAttributes(String value) {
        if (value.indexOf(44) != -1) {
            for (String portion : Splitter.on(',').omitEmptyStrings().trimResults().split(value)) {
                this.processKeepAttributes(portion);
            }
            return;
        }
        ResourceUrl url = ResourceUrl.parse(value);
        if (url == null || url.isFramework()) {
            return;
        }
        Resource resource = this.getResource(url.type, url.name);
        if (resource != null) {
            ResourceUsageModel.markReachable(resource);
            this.addResourceToWhitelist(resource);
        } else if (url.name.contains("*") || url.name.contains("?")) {
            String regexp = SdkUtils.globToRegexp(ResourcesUtil.resourceNameToFieldName(url.name));
            try {
                Pattern pattern = Pattern.compile(regexp);
                Map<String, Resource> nameMap = this.mTypeToName.get((Object)url.type);
                if (nameMap != null) {
                    for (Resource r : nameMap.values()) {
                        if (!pattern.matcher(r.name).matches()) continue;
                        ResourceUsageModel.markReachable(r);
                        this.addResourceToWhitelist(r);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private void processDiscardAttributes(String value) {
        if (value.indexOf(44) != -1) {
            for (String portion : Splitter.on(',').omitEmptyStrings().trimResults().split(value)) {
                this.processDiscardAttributes(portion);
            }
            return;
        }
        ResourceUrl url = ResourceUrl.parse(value);
        if (url == null || url.isFramework()) {
            return;
        }
        Resource resource = this.getResource(url.type, url.name);
        if (resource != null) {
            ResourceUsageModel.markUnreachable(resource);
        } else if (url.name.contains("*") || url.name.contains("?")) {
            String regexp = SdkUtils.globToRegexp(ResourcesUtil.resourceNameToFieldName(url.name));
            try {
                Pattern pattern = Pattern.compile(regexp);
                Map<String, Resource> nameMap = this.mTypeToName.get((Object)url.type);
                if (nameMap != null) {
                    for (Resource r : nameMap.values()) {
                        if (!pattern.matcher(r.name).matches()) continue;
                        ResourceUsageModel.markUnreachable(r);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    public void processToolsAttributes() {
        if (this.mKeepAttributes != null) {
            for (String keep : this.mKeepAttributes) {
                this.processKeepAttributes(keep);
            }
        }
        if (this.mDiscardAttributes != null) {
            for (String discard : this.mDiscardAttributes) {
                this.processDiscardAttributes(discard);
            }
        }
    }

    public void recordToolsAttributes(Attr attr) {
        if (attr == null) {
            return;
        }
        String localName = attr.getLocalName();
        String value = attr.getValue();
        if ("keep".equals(localName)) {
            this.recordKeepToolAttribute(value);
        } else if ("discard".equals(localName)) {
            this.recordDiscardToolAttribute(value);
        } else if ("shrinkMode".equals(localName)) {
            this.recordShrinkModeAttribute(value);
        }
    }

    public void recordKeepToolAttribute(String value) {
        if (this.mKeepAttributes == null) {
            this.mKeepAttributes = Lists.newArrayList();
        }
        this.mKeepAttributes.add(value);
    }

    public void recordDiscardToolAttribute(String value) {
        if (this.mDiscardAttributes == null) {
            this.mDiscardAttributes = Lists.newArrayList();
        }
        this.mDiscardAttributes.add(value);
    }

    public void recordShrinkModeAttribute(String value) {
        if ("strict".equals(value)) {
            this.mSafeMode = false;
        } else if ("safe".equals(value)) {
            this.mSafeMode = true;
        }
    }

    public List<String> getKeepAttributes() {
        return this.mKeepAttributes == null ? Collections.emptyList() : ImmutableList.copyOf(this.mKeepAttributes);
    }

    public List<String> getDiscardAttributes() {
        return this.mDiscardAttributes == null ? Collections.emptyList() : ImmutableList.copyOf(this.mDiscardAttributes);
    }

    protected Resource declareResource(ResourceType type2, String name, Node node) {
        return this.addDeclaredResource(type2, name, null, true);
    }

    protected String readText(File file) {
        try {
            return Files.asCharSource(file, Charsets.UTF_8).read();
        }
        catch (IOException ignore) {
            return "";
        }
    }

    public void visitBinaryResource(ResourceFolderType folderType, File file) {
        Resource from = null;
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(folderType);
            ResourceType type2 = types.get(0);
            assert (type2 != ResourceType.ID) : folderType;
            String fileName = file.getName();
            if (fileName.startsWith(".") || fileName.endsWith("~") || fileName.equals("Thumbs.db")) {
                return;
            }
            String name = SdkUtils.fileNameToResourceName(fileName);
            from = this.declareResource(type2, name, null);
        }
        if (folderType == ResourceFolderType.RAW) {
            String path = file.getPath();
            if (SdkUtils.endsWithIgnoreCase(path, ".html") || SdkUtils.endsWithIgnoreCase(path, ".htm")) {
                this.tokenizeHtml(from, this.readText(file));
            } else if (SdkUtils.endsWithIgnoreCase(path, ".css")) {
                this.tokenizeCss(from, this.readText(file));
            } else if (SdkUtils.endsWithIgnoreCase(path, ".js")) {
                this.tokenizeJs(from, this.readText(file));
            } else if (file.isFile() && !SdkUtils.isBitmapFile(file)) {
                this.tokenizeUnknownBinary(from, file);
            }
        }
    }

    public void visitXmlDocument(File file, ResourceFolderType folderType, Document document) {
        if (folderType == null) {
            this.recordManifestUsages(document.getDocumentElement());
            return;
        }
        Resource from = null;
        if (folderType != ResourceFolderType.VALUES) {
            List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(folderType);
            ResourceType type2 = types.get(0);
            assert (type2 != ResourceType.ID) : folderType;
            String name = SdkUtils.fileNameToResourceName(file.getName());
            from = this.declareResource(type2, name, document.getDocumentElement());
        } else if (ResourceUsageModel.isAnalyticsFile(file)) {
            return;
        }
        this.nextInlinedResourceSuffix = 1;
        this.recordResourceReferences(folderType, document.getDocumentElement(), from);
        if (folderType == ResourceFolderType.XML) {
            this.tokenizeUnknownText(this.readText(file));
        }
    }

    public static boolean isAnalyticsFile(File file) {
        return file.getPath().endsWith(ANALYTICS_FILE) && file.getName().equals(ANALYTICS_FILE);
    }

    protected boolean ignoreToolsAttributes() {
        return false;
    }

    public void recordResourceReferences(ResourceFolderType folderType, Node node, Resource from) {
        block37: {
            String text;
            Resource textResource;
            short nodeType;
            block36: {
                String name;
                String tagName;
                Resource definition;
                Element element;
                block38: {
                    int index;
                    Resource ps;
                    block39: {
                        Node child;
                        nodeType = node.getNodeType();
                        if (nodeType != 1) break block36;
                        element = (Element)node;
                        if ("attr".equals(element.getLocalName()) && "http://schemas.android.com/aapt".equals(element.getNamespaceURI()) && from != null) {
                            String base = from.name;
                            for (Node child2 = element.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                                if (child2.getNodeType() != 1) continue;
                                String name2 = base + '_' + Integer.toString(this.nextInlinedResourceSuffix++);
                                Resource inlined2 = this.addResource(from.type, name2, null);
                                from.addReference(inlined2);
                            }
                        }
                        if (from != null) {
                            NamedNodeMap attributes = element.getAttributes();
                            int n = attributes.getLength();
                            for (int i2 = 0; i2 < n; ++i2) {
                                int resourceEndIndex;
                                int dbExpressionStartIndex;
                                String value;
                                Attr attr = (Attr)attributes.item(i2);
                                if ("http://schemas.android.com/tools".equals(attr.getNamespaceURI())) {
                                    this.recordToolsAttributes(attr);
                                    if (this.ignoreToolsAttributes()) continue;
                                }
                                if (!(value = attr.getValue()).startsWith("@") && !value.startsWith("?")) {
                                    String name3 = attr.getLocalName();
                                    if (!"constraint_referenced_ids".equals(name3)) continue;
                                    Splitter splitter = Splitter.on(',').trimResults().omitEmptyStrings();
                                    for (String id : splitter.split(value)) {
                                        ResourceUsageModel.markReachable(this.addResource(ResourceType.ID, id, null));
                                    }
                                    continue;
                                }
                                ResourceUrl url = ResourceUrl.parse(value);
                                if (url != null && !url.isFramework()) {
                                    if (url.isCreate()) {
                                        boolean isId = "id".equals(attr.getLocalName());
                                        if (isId && "layout".equals(element.getOwnerDocument().getDocumentElement().getTagName())) {
                                            ResourceUsageModel.markReachable(this.addResource(url.type, url.name, null));
                                            continue;
                                        }
                                        if (isId && "action".equals(element.getTagName()) && "navigation".equals(element.getOwnerDocument().getDocumentElement().getTagName())) {
                                            ResourceUsageModel.markReachable(this.addResource(url.type, url.name, null));
                                            continue;
                                        }
                                        Resource resource = this.declareResource(url.type, url.name, attr);
                                        if (!isId || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                                            from.addReference(resource);
                                            continue;
                                        }
                                        if (!"fragment".equals(element.getTagName())) continue;
                                        ResourceUsageModel.markReachable(resource);
                                        continue;
                                    }
                                    Resource resource = this.addResource(url.type, url.name, null);
                                    from.addReference(resource);
                                    continue;
                                }
                                if (!value.startsWith("@{") && !value.startsWith("@={")) continue;
                                int length = value.length();
                                int resourceStartIndex = dbExpressionStartIndex = value.startsWith("@={") ? "@={".length() : "@{".length();
                                while ((resourceStartIndex = value.indexOf(64, resourceStartIndex)) != -1) {
                                    char c;
                                    for (resourceEndIndex = resourceStartIndex + 1; resourceEndIndex < length && (Character.isJavaIdentifierPart(c = value.charAt(resourceEndIndex)) || c == '_' || c == '.' || c == '/' || c == '+'); ++resourceEndIndex) {
                                    }
                                    url = ResourceUrl.parse(value.substring(resourceStartIndex, resourceEndIndex));
                                    if (url != null && !url.isFramework()) {
                                        Resource resource = url.isCreate() ? this.declareResource(url.type, url.name, attr) : this.addResource(url.type, url.name, null);
                                        from.addReference(resource);
                                    }
                                    resourceStartIndex = resourceEndIndex;
                                }
                                resourceStartIndex = dbExpressionStartIndex;
                                while ((resourceStartIndex = value.indexOf("R.", resourceStartIndex)) != -1) {
                                    ResourceType type2;
                                    if (Character.isJavaIdentifierPart(value.charAt(resourceStartIndex - 1))) continue;
                                    for (resourceEndIndex = resourceStartIndex + 2; resourceEndIndex < length && (Character.isJavaIdentifierPart(value.charAt(resourceEndIndex)) || value.charAt(resourceEndIndex) == '.'); ++resourceEndIndex) {
                                    }
                                    String[] tokens = value.substring(resourceStartIndex + 2, resourceEndIndex).split("\\.");
                                    if (tokens.length == 2 && (type2 = ResourceType.fromClassName(tokens[0])) != null) {
                                        from.addReference(this.addResource(type2, tokens[1], null));
                                    }
                                    resourceStartIndex = resourceEndIndex;
                                }
                            }
                            if ("rawPathResId".equals(element.getTagName())) {
                                StringBuilder sb = new StringBuilder();
                                NodeList children = node.getChildNodes();
                                int n2 = children.getLength();
                                for (int i3 = 0; i3 < n2; ++i3) {
                                    child = children.item(i3);
                                    if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                                    sb.append(child.getNodeValue());
                                }
                                if (sb.length() > 0) {
                                    Resource resource = this.getResource(ResourceType.RAW, sb.toString().trim());
                                    from.addReference(resource);
                                }
                            }
                        } else {
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "keep"));
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "discard"));
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "shrinkMode"));
                        }
                        if (folderType != ResourceFolderType.VALUES) break block37;
                        definition = null;
                        ResourceType type3 = ResourceType.fromXmlTag(element);
                        if (type3 != null) {
                            String name4 = ResourceUsageModel.getResourceFieldName(element);
                            if (name4.isEmpty()) {
                                return;
                            }
                            if (type3 == ResourceType.PUBLIC) {
                                String typeName = element.getAttribute("type");
                                if (!typeName.isEmpty() && (type3 = ResourceType.fromXmlValue(typeName)) != null) {
                                    definition = this.declareResource(type3, name4, element);
                                    definition.setPublic(true);
                                }
                            } else {
                                definition = this.declareResource(type3, name4, element);
                            }
                        }
                        if (definition != null) {
                            from = definition;
                        }
                        if (type3 == ResourceType.STRING) {
                            NodeList children = node.getChildNodes();
                            int n = children.getLength();
                            for (int i4 = 0; i4 < n; ++i4) {
                                child = children.item(i4);
                                if (child.getNodeType() == 1) continue;
                                this.recordResourceReferences(folderType, child, from);
                            }
                            return;
                        }
                        tagName = element.getTagName();
                        if (!"style".equals(tagName)) break block38;
                        if (!element.hasAttribute("parent")) break block39;
                        String parent = element.getAttribute("parent");
                        if (parent.isEmpty() || parent.startsWith("@android:style/") || parent.startsWith("android:")) break block38;
                        String parentStyle = parent;
                        if (!parentStyle.startsWith("@style/")) {
                            parentStyle = parentStyle.startsWith("style/") ? "@" + parentStyle : "@style/" + parentStyle;
                        }
                        if ((ps = this.getResourceFromUrl(ResourcesUtil.resourceNameToFieldName(parentStyle))) == null || definition == null) break block38;
                        definition.addReference(ps);
                        break block38;
                    }
                    String name5 = ResourceUsageModel.getResourceFieldName(element);
                    while ((index = name5.lastIndexOf(95)) != -1) {
                        name5 = name5.substring(0, index);
                        ps = this.getResourceFromUrl("@style/" + ResourcesUtil.resourceNameToFieldName(name5));
                        if (ps == null || definition == null) continue;
                        definition.addReference(ps);
                    }
                }
                if ("item".equals(tagName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("style") && !(name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty() && !name.startsWith("android:")) {
                    Element style;
                    Resource resource = this.getResource(ResourceType.ATTR, name);
                    if (definition == null && (definition = this.getResource(style = (Element)element.getParentNode())) != null) {
                        from = definition;
                        definition.addReference(resource);
                    }
                }
                break block37;
            }
            if ((nodeType == 3 || nodeType == 4) && (textResource = this.getResourceFromUrl(ResourcesUtil.resourceNameToFieldName(text = node.getNodeValue().trim()))) != null && from != null) {
                from.addReference(textResource);
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i5 = 0; i5 < n; ++i5) {
            Node child = children.item(i5);
            this.recordResourceReferences(folderType, child, from);
        }
    }

    public void tokenizeHtml(Resource from, String html) {
        int length = html.length();
        boolean STATE_TEXT = true;
        int STATE_SLASH = 2;
        int STATE_ATTRIBUTE_NAME = 3;
        int STATE_BEFORE_TAG = 4;
        int STATE_IN_TAG = 5;
        int STATE_BEFORE_ATTRIBUTE = 6;
        int STATE_ATTRIBUTE_BEFORE_EQUALS = 7;
        int STATE_ATTRIBUTE_AFTER_EQUALS = 8;
        int STATE_ATTRIBUTE_VALUE_NONE = 9;
        int STATE_ATTRIBUTE_VALUE_SINGLE = 10;
        int STATE_ATTRIBUTE_VALUE_DOUBLE = 11;
        int STATE_CLOSE_TAG = 12;
        int STATE_ENDING_TAG = 13;
        int state = 1;
        int offset = 0;
        int valueStart = 0;
        int tagStart = 0;
        String tag = null;
        String attribute = null;
        int attributeStart = 0;
        int prev = -1;
        block15: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = html.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '<') {
                        state = 2;
                        ++offset;
                        continue block15;
                    }
                    ++offset;
                    continue block15;
                }
                case 2: {
                    int end;
                    if (c == '!') {
                        if (html.startsWith("!--", offset)) {
                            end = html.indexOf("-->", offset + 3);
                            if (end == -1) {
                                offset = length;
                                continue block15;
                            }
                            state = 1;
                            offset = end + 3;
                            continue block15;
                        }
                        if (html.startsWith("![CDATA[", offset)) {
                            end = html.indexOf("]]>", offset + 8);
                            if (end == -1) {
                                offset = length;
                                continue block15;
                            }
                            state = 1;
                            offset = end + 3;
                            continue block15;
                        }
                    } else {
                        if (c == '/') {
                            state = 12;
                            ++offset;
                            continue block15;
                        }
                        if (c == '?') {
                            end = html.indexOf(62, offset + 2);
                            if (end == -1) {
                                offset = length;
                                state = 1;
                                continue block15;
                            }
                            offset = end + 1;
                            state = 1;
                            continue block15;
                        }
                    }
                    state = 5;
                    tagStart = offset;
                    continue block15;
                }
                case 12: {
                    if (c == '>') {
                        state = 1;
                    }
                    ++offset;
                    continue block15;
                }
                case 4: {
                    if (!Character.isWhitespace(c)) {
                        state = 5;
                        tagStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 5: {
                    if (Character.isWhitespace(c)) {
                        state = 6;
                        tag = html.substring(tagStart, offset).trim();
                    } else if (c == '>') {
                        tag = html.substring(tagStart, offset).trim();
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (c == '/') {
                        tag = html.substring(tagStart, offset).trim();
                        this.endHtmlTag(from, html, offset, tag);
                        state = 13;
                    }
                    ++offset;
                    continue block15;
                }
                case 13: {
                    if (c != '>') continue block15;
                    ++offset;
                    state = 1;
                    continue block15;
                }
                case 6: {
                    if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (c != '/' && !Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 3: {
                    if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (c == '=') {
                        attribute = html.substring(attributeStart, offset);
                        state = 8;
                    } else if (Character.isWhitespace(c)) {
                        attribute = html.substring(attributeStart, offset);
                        state = 7;
                    }
                    ++offset;
                    continue block15;
                }
                case 7: {
                    if (c == '=') {
                        state = 8;
                    } else if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 8: {
                    if (c == '\'') {
                        state = 10;
                        valueStart = offset + 1;
                    } else if (c == '\"') {
                        state = 11;
                        valueStart = offset + 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 9;
                        valueStart = offset + 1;
                    }
                    ++offset;
                    continue block15;
                }
                case 10: {
                    if (c == '\'') {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
                case 11: {
                    if (c == '\"') {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
                case 9: {
                    if (c == '>') {
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (Character.isWhitespace(c)) {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
            }
            assert (false) : state;
        }
    }

    private void endHtmlTag(Resource from, String html, int offset, String tag) {
        int end;
        if ("script".equals(tag)) {
            int end2 = html.indexOf("</script>", offset + 1);
            if (end2 != -1) {
                String js = html.substring(offset + 1, end2);
                this.tokenizeJs(from, js);
            }
        } else if ("style".equals(tag) && (end = html.indexOf("</style>", offset + 1)) != -1) {
            String css = html.substring(offset + 1, end);
            this.tokenizeCss(from, css);
        }
    }

    public void tokenizeJs(Resource from, String js) {
        int length = js.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int STATE_STRING_DOUBLE = 3;
        int STATE_STRING_DOUBLE_QUOTED = 4;
        int STATE_STRING_SINGLE = 5;
        int STATE_STRING_SINGLE_QUOTED = 6;
        int state = 1;
        int offset = 0;
        int stringStart = 0;
        int prev = -1;
        block8: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = js.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '/') {
                        state = 2;
                    } else if (c == '\"') {
                        stringStart = offset + 1;
                        state = 3;
                    } else if (c == '\'') {
                        stringStart = offset + 1;
                        state = 5;
                    }
                    ++offset;
                    continue block8;
                }
                case 2: {
                    int end;
                    if (c == '*') {
                        state = 1;
                        end = js.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 2;
                        continue block8;
                    }
                    if (c == '/') {
                        state = 1;
                        end = js.indexOf(10, offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 1;
                        continue block8;
                    }
                    state = 1;
                    ++offset;
                    continue block8;
                }
                case 3: {
                    if (c == '\"') {
                        this.recordJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 4;
                    }
                    ++offset;
                    continue block8;
                }
                case 4: {
                    state = 3;
                    ++offset;
                    continue block8;
                }
                case 5: {
                    if (c == '\'') {
                        this.recordJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 6;
                    }
                    ++offset;
                    continue block8;
                }
                case 6: {
                    state = 5;
                    ++offset;
                    continue block8;
                }
            }
            assert (false) : state;
        }
    }

    public void tokenizeCss(Resource from, String css) {
        int length = css.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int state = 1;
        int offset = 0;
        int prev = -1;
        block4: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = css.charAt(offset);
            switch (state) {
                case 1: {
                    char prevChar;
                    if (c == '/') {
                        state = 2;
                    } else if (c == 'u' && css.startsWith("url(", offset) && offset > 0 && (Character.isWhitespace(prevChar = css.charAt(offset - 1)) || prevChar == ':')) {
                        int end = css.indexOf(41, offset);
                        offset += 4;
                        while (offset < length && Character.isWhitespace(css.charAt(offset))) {
                            ++offset;
                        }
                        if (end != -1 && end > offset + 1) {
                            while (end > offset && Character.isWhitespace(css.charAt(end - 1))) {
                                --end;
                            }
                            if (css.charAt(offset) == '\"' && css.charAt(end - 1) == '\"' || css.charAt(offset) == '\'' && css.charAt(end - 1) == '\'') {
                                ++offset;
                                --end;
                            }
                            this.recordCssUrl(from, css.substring(offset, end).trim());
                        }
                        offset = end + 1;
                        continue block4;
                    }
                    ++offset;
                    continue block4;
                }
                case 2: {
                    if (c == '*') {
                        int end = css.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block4;
                        }
                        offset = end + 2;
                        continue block4;
                    }
                    state = 1;
                    ++offset;
                    continue block4;
                }
            }
            assert (false) : state;
        }
    }

    public void tokenizeUnknownBinary(Resource from, File file) {
        try {
            this.tokenizeUnknownBinary(from, Files.toByteArray(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void tokenizeUnknownBinary(Resource from, byte[] bytes) throws IOException {
        if (sAndroidResBytes == null) {
            sAndroidResBytes = ANDROID_RES.getBytes("UTF-8");
        }
        int index = 0;
        block0: while (index != -1) {
            int begin;
            if ((index = ResourceUsageModel.indexOf(bytes, sAndroidResBytes, index)) == -1) continue;
            for (int end = begin = (index += sAndroidResBytes.length); end < bytes.length; ++end) {
                byte c = bytes[end];
                if (c == 47 || Character.isJavaIdentifierPart((char)c)) continue;
                String url = "@" + new String(bytes, begin, end - begin, Charsets.UTF_8);
                Resource resource = this.getResourceFromUrl(url);
                if (resource == null) continue block0;
                if (from != null) {
                    from.addReference(resource);
                    continue block0;
                }
                ResourceUsageModel.markReachable(resource);
                continue block0;
            }
        }
    }

    private static int indexOf(byte[] array, byte[] target, int fromIndex) {
        block0: for (int i2 = fromIndex; i2 < array.length - target.length + 1; ++i2) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i2 + j] != target[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    private void tokenizeUnknownText(String text) {
        int index = 0;
        block0: while (index != -1) {
            int begin;
            if ((index = text.indexOf(ANDROID_RES, index)) == -1) continue;
            int length = text.length();
            for (int end = begin = (index += ANDROID_RES.length()); end < length; ++end) {
                char c = text.charAt(end);
                if (c == '/' || Character.isJavaIdentifierPart(c)) continue;
                ResourceUsageModel.markReachable(this.getResourceFromUrl("@" + text.substring(begin, end)));
                continue block0;
            }
        }
    }

    public void tokenizeKotlinCode(String s2) {
        this.tokenizeJavaCode(s2);
    }

    public void tokenizeJavaCode(String s2) {
        if (s2.length() <= 2) {
            return;
        }
        int length = s2.length();
        block0: for (int index = 0; index < length; ++index) {
            char c = s2.charAt(index);
            if (index == length - 1) break;
            char next = s2.charAt(index + 1);
            if (Character.isWhitespace(c)) continue;
            if (c == '/') {
                if (next == '*') {
                    while (index < length - 2 && (s2.charAt(index) != '*' || s2.charAt(index + 1) != '/')) {
                        ++index;
                    }
                    ++index;
                    continue;
                }
                if (next != '/') continue;
                while (index < length && s2.charAt(index) != '\n') {
                    ++index;
                }
                continue;
            }
            if (c == '\'') {
                if (next == '\\') {
                    index += 2;
                    continue;
                }
                ++index;
                continue;
            }
            if (c == '\"') {
                ++index;
                while (index < length - 1) {
                    char t = s2.charAt(index);
                    if (t == '\\') {
                        ++index;
                    } else if (t == '\"') continue block0;
                    ++index;
                }
                continue;
            }
            if (c == 'R' && next == '.') {
                int begin = index;
                index += 2;
                while (index < length) {
                    char t = s2.charAt(index);
                    if (t == '.') {
                        String typeName = s2.substring(begin + 2, index);
                        ResourceType type2 = ResourceType.fromClassName(typeName);
                        if (type2 != null) {
                            begin = ++index;
                            while (index < length && Character.isJavaIdentifierPart(s2.charAt(index))) {
                                ++index;
                            }
                            if (index > begin) {
                                String name = s2.substring(begin, index);
                                Resource resource = this.addResource(type2, name, null);
                                ResourceUsageModel.markReachable(resource);
                            }
                        }
                        --index;
                        continue block0;
                    }
                    if (!Character.isJavaIdentifierStart(t)) continue block0;
                    ++index;
                }
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            while (index < length && Character.isJavaIdentifierPart(s2.charAt(index))) {
                ++index;
            }
            --index;
        }
    }

    protected void referencedString(String string) {
    }

    private void recordCssUrl(Resource from, String value) {
        if (!this.referencedUrl(from, value)) {
            this.referencedString(value);
        }
    }

    private boolean referencedUrl(Resource from, String url) {
        Resource resource = this.getResourceFromFilePath(url);
        if (resource == null && url.indexOf(47) == -1) {
            resource = this.getResource(ResourceType.RAW, ResourcesUtil.resourceNameToFieldName(SdkUtils.fileNameToResourceName(url)));
        }
        if (resource != null) {
            if (from != null) {
                from.addReference(resource);
            } else {
                ResourceUsageModel.markReachable(resource);
            }
            return true;
        }
        return false;
    }

    private void recordHtmlAttributeValue(Resource from, String tagName, String attribute, String value) {
        if ("href".equals(attribute) || "src".equals(attribute)) {
            if (!this.referencedUrl(from, value)) {
                this.referencedString(value);
            }
            if (from != null) {
                from.addReference(this.getResourceFromFilePath(attribute));
            }
        }
    }

    private void recordJsString(String string) {
        this.referencedString(string);
    }

    public List<Resource> getResources() {
        return this.mResources;
    }

    public Collection<Map<String, Resource>> getResourceMaps() {
        return this.mTypeToName.values();
    }

    public static class Resource
    implements Comparable<Resource> {
        private int mFlags;
        public final ResourceType type;
        public final String name;
        public int value;
        public List<Resource> references;
        public List<Path> declarations;

        public boolean isDeclared() {
            return (this.mFlags & 2) != 0;
        }

        public void setDeclared(boolean on) {
            this.mFlags = on ? this.mFlags | 2 : this.mFlags & 0xFFFFFFFD;
        }

        public boolean isPublic() {
            return (this.mFlags & 4) != 0;
        }

        public void setPublic(boolean on) {
            this.mFlags = on ? this.mFlags | 4 : this.mFlags & 0xFFFFFFFB;
        }

        public boolean isKeep() {
            return (this.mFlags & 8) != 0;
        }

        public void setKeep(boolean on) {
            this.mFlags = on ? this.mFlags | 8 : this.mFlags & 0xFFFFFFF7;
        }

        public boolean isDiscard() {
            return (this.mFlags & 0x10) != 0;
        }

        public void setDiscard(boolean on) {
            this.mFlags = on ? this.mFlags | 0x10 : this.mFlags & 0xFFFFFFEF;
        }

        public boolean isReachable() {
            return (this.mFlags & 0x20) != 0;
        }

        public void setReachable(boolean on) {
            this.mFlags = on ? this.mFlags | 0x20 : this.mFlags & 0xFFFFFFDF;
        }

        public Resource(ResourceType type2, String name, int value) {
            this.type = type2;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + this.name + ":" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (!Objects.equals(this.name, resource.name)) {
                return false;
            }
            return this.type == resource.type;
        }

        public int hashCode() {
            int result2 = this.type != null ? this.type.hashCode() : 0;
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            return result2;
        }

        public void addLocation(File file) {
            this.addLocation(file.toPath());
        }

        public void addLocation(Path path) {
            if (this.declarations == null) {
                this.declarations = Lists.newArrayList();
            }
            this.declarations.add(path);
        }

        public void addReference(Resource resource) {
            if (resource != null) {
                if (this.references == null) {
                    this.references = Lists.newArrayList();
                } else if (this.references.contains(resource)) {
                    return;
                }
                this.references.add(resource);
            }
        }

        public String getUrl() {
            return '@' + this.type.getName() + '/' + this.name;
        }

        public String getField() {
            return "R." + this.type.getName() + '.' + this.name;
        }

        @Override
        public int compareTo(Resource other) {
            if (this.type != other.type) {
                return this.type.compareTo(other.type);
            }
            return this.name.compareTo(other.name);
        }
    }

    public static enum ResourceActions {
        REMOVE("remove"),
        NO_OBFUSCATE("no_obfuscate");

        private String repr;

        private ResourceActions(String repr) {
            this.repr = repr;
        }

        public String toString() {
            return this.repr;
        }
    }
}

