/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ScreenDimensionQualifier
extends ResourceQualifier {
    static final int DEFAULT_SIZE = -1;
    private static final Pattern sDimensionPattern = Pattern.compile("^(\\d+)x(\\d+)$");
    public static final String NAME = "Screen Dimension";
    private final int mValue1;
    private final int mValue2;
    private final String mShortDisplayValue;

    public ScreenDimensionQualifier(int value1, int value2) {
        this.mValue1 = value1;
        this.mValue2 = value2;
        this.mShortDisplayValue = String.format("%1$dx%2$d", value1, value2);
    }

    public ScreenDimensionQualifier() {
        this(-1, -1);
    }

    public int getValue1() {
        return this.mValue1;
    }

    public int getValue2() {
        return this.mValue2;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Dimension";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean deprecated() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.mValue1 != -1 && this.mValue2 != -1;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        String d2;
        String d1;
        ScreenDimensionQualifier qualifier;
        Matcher m3 = sDimensionPattern.matcher(value);
        if (m3.matches() && (qualifier = ScreenDimensionQualifier.getQualifier(d1 = m3.group(1), d2 = m3.group(2))) != null) {
            config.setScreenDimensionQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof ScreenDimensionQualifier) {
            ScreenDimensionQualifier q = (ScreenDimensionQualifier)qualifier;
            return this.mValue1 == q.mValue1 && this.mValue2 == q.mValue2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public static ScreenDimensionQualifier getQualifier(String size1, String size2) {
        try {
            int value2;
            int value1;
            int s1 = Integer.parseInt(size1);
            int s2 = Integer.parseInt(size2);
            if (s1 > s2) {
                value1 = s1;
                value2 = s2;
            } else {
                value1 = s2;
                value2 = s1;
            }
            return new ScreenDimensionQualifier(value1, value2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String getFolderSegment() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getShortDisplayValue() {
        if (this.isValid()) {
            return this.getFolderSegment();
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.isValid()) {
            return "Screen resolution " + this.getFolderSegment();
        }
        return "";
    }
}

