/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.CharacterHandler;
import com.android.ide.common.resources.ValueXmlHelper;

final class StringResourceUnescaperCharacterHandler
implements CharacterHandler {
    StringResourceUnescaperCharacterHandler() {
    }

    @Override
    public void handle(StringBuilder builder, char[] chars, int offset, int length) {
        String string = StringResourceUnescaperCharacterHandler.stripUnescapedQuotes(chars, offset, length);
        string = StringResourceUnescaperCharacterHandler.unescape(string);
        builder.append(string);
    }

    private static String stripUnescapedQuotes(char[] chars, int offset, int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i2 = offset; i2 < offset + length; ++i2) {
            if (chars[i2] == '\"') {
                if (!StringResourceUnescaperCharacterHandler.isEscaped(chars, offset, length, i2)) continue;
                builder.append('\"');
                continue;
            }
            builder.append(chars[i2]);
        }
        return builder.toString();
    }

    private static boolean isEscaped(char[] chars, int offset, int length, int index) {
        return ValueXmlHelper.isEscaped(new String(chars, offset, length), index - offset);
    }

    private static String unescape(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i2 = length - 1; i2 >= 0; --i2) {
            if (StringResourceUnescaperCharacterHandler.shouldUnescape(string, i2)) {
                builder.append(StringResourceUnescaperCharacterHandler.getReplacement(string.charAt(i2)));
                --i2;
                continue;
            }
            builder.append(string.charAt(i2));
        }
        return builder.reverse().toString();
    }

    private static boolean shouldUnescape(String string, int index) {
        switch (string.charAt(index)) {
            case ' ': 
            case '\"': 
            case '\'': 
            case '\\': 
            case 'n': 
            case 't': {
                return ValueXmlHelper.isEscaped(string, index);
            }
        }
        return false;
    }

    private static char getReplacement(char c) {
        switch (c) {
            case ' ': 
            case '\"': 
            case '\'': 
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
        }
        throw new IllegalArgumentException(String.valueOf(c));
    }
}

