/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.CharacterHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

final class StringResourceContentHandler
extends DefaultHandler2 {
    private final StringBuilder mBuilder;
    private final CharacterHandler mCharacterHandler;
    private boolean mHandlingEntity;
    private boolean mHandlingCdata;
    private int mStartElementBuilderLength;

    StringResourceContentHandler(StringBuilder builder, CharacterHandler characterHandler) {
        this.mBuilder = builder;
        this.mCharacterHandler = characterHandler;
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        if (this.mHandlingEntity) {
            this.mHandlingEntity = false;
            return;
        }
        if (this.mHandlingCdata) {
            this.mBuilder.append(chars, offset, length);
        } else {
            this.mCharacterHandler.handle(this.mBuilder, chars, offset, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName2, Attributes attributes) throws SAXException {
        if (qualifiedName2.equals("string")) {
            return;
        }
        this.mBuilder.append('<').append(qualifiedName2);
        int length = attributes.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            this.mBuilder.append(' ').append(attributes.getQName(i2)).append("=\"").append(attributes.getValue(i2)).append('\"');
        }
        this.mBuilder.append('>');
        this.mStartElementBuilderLength = this.mBuilder.length();
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName2) throws SAXException {
        if (qualifiedName2.equals("string")) {
            return;
        }
        if (this.mBuilder.length() == this.mStartElementBuilderLength) {
            this.mBuilder.setCharAt(this.mBuilder.length() - 1, '/');
            this.mBuilder.append('>');
        } else {
            this.mBuilder.append("</").append(qualifiedName2).append('>');
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.mBuilder.append('&').append(name).append(';');
        this.mHandlingEntity = true;
    }

    @Override
    public void startCDATA() throws SAXException {
        this.mBuilder.append("<![CDATA[");
        this.mHandlingCdata = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.mBuilder.append("]]>");
        this.mHandlingCdata = false;
    }

    @Override
    public void comment(char[] chars, int offset, int length) throws SAXException {
        this.mBuilder.append("<!--").append(chars, offset, length).append("-->");
    }

    @Override
    public void processingInstruction(String target, String data2) throws SAXException {
        this.mBuilder.append("<?").append(target).append(' ').append(data2).append("?>");
    }
}

