/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.HashMap;
import java.util.List;

public final class ResourceTable
extends ForwardingTable<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> {
    private final Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));

    @Override
    protected Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate() {
        return this.delegate;
    }

    public void remove(ResourceItem resourceItem) {
        ResourceNamespace namespace = resourceItem.getNamespace();
        ResourceType type2 = resourceItem.getType();
        String name = resourceItem.getName();
        ListMultimap multimap = (ListMultimap)this.get(namespace, (Object)type2);
        if (multimap != null) {
            multimap.remove(name, resourceItem);
            if (multimap.isEmpty()) {
                this.remove(namespace, (Object)type2);
            }
        }
    }

    public ListMultimap<String, ResourceItem> getOrPutEmpty(ResourceNamespace namespace, ResourceType resourceType) {
        ArrayListMultimap<String, ResourceItem> multimap = (ArrayListMultimap<String, ResourceItem>)this.get(namespace, (Object)resourceType);
        if (multimap == null) {
            multimap = ArrayListMultimap.create();
            this.put(namespace, resourceType, multimap);
        }
        return multimap;
    }

    public List<ResourceItem> get(ResourceReference reference) {
        ListMultimap multimap = (ListMultimap)this.get(reference.getNamespace(), (Object)reference.getResourceType());
        if (multimap == null) {
            return null;
        }
        return multimap.get(reference.getName());
    }
}

