/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceTable;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;

public class ResourceRepositories {
    private static final Ordering<ResourceItem> ORDERING_BY_KEY = Ordering.from(Comparator.comparing(ResourceItem::getKey));

    private ResourceRepositories() {
    }

    public static void sortItemLists(ListMultimap<String, ResourceItem> multimap) {
        ArrayListMultimap sorted2 = ArrayListMultimap.create();
        for (Map.Entry<String, Collection<ResourceItem>> entry : multimap.asMap().entrySet()) {
            sorted2.putAll(entry.getKey(), ORDERING_BY_KEY.sortedCopy(entry.getValue()));
        }
        multimap.clear();
        multimap.putAll(sorted2);
    }

    public static void updateTableFromMerger(ResourceMerger merger, final ResourceTable fullTable) {
        MergeConsumer<ResourceMergerItem> consumer = new MergeConsumer<ResourceMergerItem>(){

            @Override
            public void start(DocumentBuilderFactory factory) {
            }

            @Override
            public void end() {
            }

            @Override
            public void addItem(ResourceMergerItem item) {
                ListMultimap<String, ResourceItem> multimap;
                if (item.isTouched() && !(multimap = fullTable.getOrPutEmpty(item.getNamespace(), item.getType())).containsEntry(item.getName(), item)) {
                    multimap.put(item.getName(), item);
                }
            }

            @Override
            public void removeItem(ResourceMergerItem removedItem, ResourceMergerItem replacedBy) {
                fullTable.remove(removedItem);
            }

            @Override
            public boolean ignoreItemInMerge(ResourceMergerItem item) {
                return false;
            }
        };
        try {
            merger.mergeData(consumer, true);
        }
        catch (MergingException e) {
            throw new RuntimeException(e);
        }
    }
}

