/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class ResourceNameKeyedMap<T>
extends THashMap<String, T> {
    private static TObjectHashingStrategy<String> NORMALIZED_RESOURCE_NAME_STRATEGY = new TObjectHashingStrategy<String>(){

        @Override
        public int computeHashCode(@NotNull String object) {
            int result2 = 0;
            for (int i2 = 0; i2 < object.length(); ++i2) {
                result2 = result2 * 31 + this.normalize(object.charAt(i2));
            }
            return result2;
        }

        @Override
        public boolean equals(@NotNull String o1, @NotNull String o2) {
            if (o1.length() != o2.length()) {
                return false;
            }
            for (int i2 = o1.length() - 1; i2 >= 0; --i2) {
                char c2;
                char c1 = this.normalize(o1.charAt(i2));
                if (c1 == (c2 = this.normalize(o2.charAt(i2)))) continue;
                return false;
            }
            return true;
        }

        private char normalize(char c) {
            if (ResourcesUtil.isInvalidResourceFieldNameCharacter(c)) {
                return '_';
            }
            return c;
        }
    };

    public ResourceNameKeyedMap() {
        super(NORMALIZED_RESOURCE_NAME_STRATEGY);
    }

    public ResourceNameKeyedMap(int expectedSize) {
        super(expectedSize, NORMALIZED_RESOURCE_NAME_STRATEGY);
    }
}

