/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResourceFile
extends DataFile<ResourceMergerItem> {
    static final String ATTR_QUALIFIER = "qualifiers";
    private FolderConfiguration mFolderConfiguration;

    public ResourceFile(File file, ResourceMergerItem item, FolderConfiguration folderConfiguration) {
        super(file, DataFile.FileType.SINGLE_FILE);
        this.mFolderConfiguration = folderConfiguration;
        this.init(item);
    }

    public ResourceFile(File file, List<ResourceMergerItem> items, FolderConfiguration folderConfiguration) {
        this(file, items, folderConfiguration, DataFile.FileType.XML_VALUES);
    }

    private ResourceFile(File file, List<ResourceMergerItem> items, FolderConfiguration folderConfiguration, DataFile.FileType fileType) {
        super(file, fileType);
        this.mFolderConfiguration = folderConfiguration;
        this.init(items);
    }

    public static ResourceFile generatedFiles(File file, List<ResourceMergerItem> items, FolderConfiguration folderConfiguration) {
        return new ResourceFile(file, items, folderConfiguration, DataFile.FileType.GENERATED_FILES);
    }

    @VisibleForTesting
    public static ResourceFile createSingle(File file, ResourceMergerItem item, String qualifiers) {
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifiers);
        assert (folderConfiguration != null);
        return new ResourceFile(file, item, folderConfiguration);
    }

    public String getQualifiers() {
        return this.mFolderConfiguration.getQualifierString();
    }

    public void setQualifiers(String qualifiers) {
        this.mFolderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifiers);
    }

    public FolderConfiguration getFolderConfiguration() {
        return this.mFolderConfiguration;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, namespaceUri, ATTR_QUALIFIER, this.getQualifiers());
        if (this.getType() == DataFile.FileType.GENERATED_FILES) {
            NodeUtils.addAttribute(document, node, namespaceUri, "preprocessing", "true");
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mFile", this.mFile).toString();
    }
}

