/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.MergingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;

public interface MergeConsumer<I extends DataItem> {
    public void start(DocumentBuilderFactory var1) throws ConsumerException;

    public void end() throws ConsumerException;

    public void addItem(I var1) throws ConsumerException;

    public void removeItem(I var1, I var2) throws ConsumerException;

    public boolean ignoreItemInMerge(I var1);

    public static class ConsumerException
    extends MergingException {
        public ConsumerException(Throwable cause) {
            this(cause, SourceFile.UNKNOWN);
        }

        public ConsumerException(Throwable cause, File file) {
            this(cause, new SourceFile(file));
        }

        private ConsumerException(Throwable cause, SourceFile file) {
            super(cause, new Message(Message.Kind.ERROR, MoreObjects.firstNonNull(cause.getLocalizedMessage(), cause.getClass().getCanonicalName()), Throwables.getStackTraceAsString(cause), "Resource and asset merger", new SourceFilePosition(file, SourcePosition.UNKNOWN), new SourceFilePosition[0]));
        }
    }
}

