/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStrings;
import com.android.utils.XmlUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AndroidManifestPackageNameUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageNameFromManifestFile(PathString manifestFile) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(PathStrings.inputStream(manifestFile));){
            String string = AndroidManifestPackageNameUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("File " + manifestFile + " has invalid format");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageNameFromResApk(ZipFile resApk) throws IOException {
        ZipEntry zipEntry = resApk.getEntry("AndroidManifest.xml");
        if (zipEntry == null) {
            throw new IOException("\"AndroidManifest.xml\" not found in " + resApk.getName());
        }
        try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
            String string = AndroidManifestPackageNameUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Invalid AndroidManifest.xml in " + resApk.getName());
        }
    }

    private static String getPackageName(InputStream stream) throws XmlPullParserException, IOException {
        XmlPullParser parser;
        stream.mark(1);
        if (XmlUtils.isProtoXml(stream)) {
            parser = new ProtoXmlPullParser();
        } else {
            parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        parser.setInput(stream, null);
        if (parser.nextTag() == 2) {
            return parser.getAttributeValue(null, "package");
        }
        return null;
    }
}

