/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public enum SdkMavenRepository {
    ANDROID("android"),
    GOOGLE("google");

    private final String mDir;

    private SdkMavenRepository(String dir) {
        this.mDir = dir;
    }

    public File getRepositoryLocation(File sdkHome, boolean requireExists, FileOp fileOp) {
        if (sdkHome != null) {
            File dir = new File(sdkHome, "extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || fileOp.isDirectory(dir)) {
                return dir;
            }
        }
        return null;
    }

    public boolean isInstalled(File sdkHome, FileOp fileOp) {
        return this.getRepositoryLocation(sdkHome, true, fileOp) != null;
    }

    public boolean isInstalled(AndroidSdkHandler sdkHandler) {
        if (sdkHandler != null) {
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            RepoManager mgr = sdkHandler.getSdkManager(progress);
            return mgr.getPackages().getLocalPackages().containsKey(this.getPackageId());
        }
        return false;
    }

    public String getPackageId() {
        return String.format("extras;%s;%s", this.mDir, "m2repository");
    }

    public static SdkMavenRepository find(File sdkLocation, String groupId, String artifactId, FileOp fileOp) {
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            File artifactIdDirectory;
            File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
            if (repositoryLocation == null || !fileOp.exists(artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repositoryLocation, groupId, artifactId))) continue;
            return repository;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }

    public static GradleCoordinate getCoordinateFromSdkPath(String path) {
        String prefix = String.join((CharSequence)Character.toString(';'), "extras", "m2repository", "");
        if (!path.startsWith(prefix)) {
            return null;
        }
        ArrayList<String> components = Lists.newArrayList(path.split(Character.toString(';')));
        String version = (String)components.remove(components.size() - 1);
        String artifact = (String)components.remove(components.size() - 1);
        String group = String.join((CharSequence)".", components.subList(2, components.size()));
        List<GradleCoordinate.RevisionComponent> revisionComponents = GradleCoordinate.parseRevisionNumber(version);
        return new GradleCoordinate(group, artifact, revisionComponents.toArray(new GradleCoordinate.RevisionComponent[0]));
    }

    public static RepoPackage findBestPackageMatching(GradleCoordinate coordinate, Collection<? extends RepoPackage> packages2) {
        RepoPackage result2 = null;
        GradleCoordinate resultCoordinate = null;
        for (RepoPackage repoPackage : packages2) {
            GradleCoordinate test = SdkMavenRepository.getCoordinateFromSdkPath(repoPackage.getPath());
            if (test == null || !test.matches(coordinate) || resultCoordinate != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(test, resultCoordinate) <= 0) continue;
            result2 = repoPackage;
            resultCoordinate = test;
        }
        return result2;
    }

    public static LocalPackage findLatestLocalVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, Predicate<GradleVersion> filter2, ProgressIndicator progress) {
        String prefix = DetailsTypes.MavenType.getRepositoryPath(coordinate.getGroupId(), coordinate.getArtifactId(), null);
        Predicate<Revision> revisionFilter = filter2 == null ? null : revision -> filter2.test(SdkMavenRepository.revisionToGradleVersion(revision));
        return sdkHandler.getLatestLocalPackageForPrefix(prefix, revisionFilter, coordinate.isPreview(), GradleCoordinate::parseVersionOnly, GradleCoordinate.COMPARE_PLUS_LOWER, progress);
    }

    private static GradleVersion revisionToGradleVersion(Revision revision) {
        return GradleVersion.parse(revision.toString("-"));
    }

    public static RemotePackage findLatestRemoteVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, Predicate<GradleVersion> filter2, ProgressIndicator progress) {
        String prefix = DetailsTypes.MavenType.getRepositoryPath(coordinate.getGroupId(), coordinate.getArtifactId(), null);
        Predicate<Revision> revisionFilter = filter2 == null ? null : revision -> filter2.test(SdkMavenRepository.revisionToGradleVersion(revision));
        return sdkHandler.getLatestRemotePackageForPrefix(prefix, revisionFilter, coordinate.isPreview(), GradleCoordinate::parseVersionOnly, GradleCoordinate.COMPARE_PLUS_LOWER, progress);
    }

    public static RepoPackage findLatestVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, Predicate<GradleVersion> filter2, ProgressIndicator progress) {
        GradleCoordinate remoteCoordinate;
        LocalPackage local = SdkMavenRepository.findLatestLocalVersion(coordinate, sdkHandler, filter2, progress);
        RemotePackage remote = SdkMavenRepository.findLatestRemoteVersion(coordinate, sdkHandler, filter2, progress);
        if (local == null) {
            return remote;
        }
        if (remote == null) {
            return local;
        }
        GradleCoordinate localCoordinate = SdkMavenRepository.getCoordinateFromSdkPath(local.getPath());
        if (GradleCoordinate.COMPARE_PLUS_LOWER.compare(localCoordinate, remoteCoordinate = SdkMavenRepository.getCoordinateFromSdkPath(remote.getPath())) < 0) {
            return remote;
        }
        return local;
    }
}

