/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;

public class SampleDataResourceValueImpl
extends ResourceValueImpl
implements SampleDataResourceValue {
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on(Pattern.compile("\r?\n")).omitEmptyStrings();
    private final ImmutableList<String> lines;
    private final ResourceReference reference;

    public SampleDataResourceValueImpl(ResourceReference reference, byte[] content) {
        super(reference, null);
        this.reference = reference;
        this.lines = content != null ? ImmutableList.copyOf(NEW_LINE_SPLITTER.splitToList(new String(content, Charsets.UTF_8))) : ImmutableList.of();
    }

    @Override
    public String getValue() {
        return this.reference.getResourceUrl().toString();
    }

    @Override
    public ImmutableList<String> getValueAsLines() {
        return this.lines;
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }
}

