/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AttrResourceValueImpl
extends ResourceValueImpl
implements AttrResourceValue {
    private Map<String, Integer> valueMap;
    private Map<String, String> valueDescriptionMap;
    private String description;
    private String groupName;
    private Set<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);

    public AttrResourceValueImpl(ResourceNamespace namespace, String name, String libraryName) {
        super(namespace, ResourceType.ATTR, name, null, libraryName);
    }

    public AttrResourceValueImpl(ResourceReference reference, String libraryName) {
        super(reference, null, libraryName);
    }

    @Override
    public Map<String, Integer> getAttributeValues() {
        return this.valueMap == null ? Collections.emptyMap() : this.valueMap;
    }

    @Override
    public String getValueDescription(String valueName) {
        return this.valueDescriptionMap == null ? null : this.valueDescriptionMap.get(valueName);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Set<AttributeFormat> getFormats() {
        return this.formats;
    }

    public void addValue(String valueName, Integer numericValue, String description2) {
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, Integer>();
        }
        this.valueMap.put(valueName, numericValue);
        if (description2 != null) {
            if (this.valueDescriptionMap == null) {
                this.valueDescriptionMap = new HashMap<String, String>();
            }
            this.valueDescriptionMap.put(valueName, description2);
        }
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setFormats(Collection<AttributeFormat> formats) {
        this.formats = EnumSet.copyOf(formats);
    }
}

