/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessResult;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;

class ProcessResultImpl
implements ProcessResult {
    private final ImmutableList<String> mCommand;
    private final int mExitValue;
    private final Throwable mFailure;

    ProcessResultImpl(List<String> command, int exitValue) {
        this(command, exitValue, null);
    }

    ProcessResultImpl(List<String> command, Throwable failure) {
        this(command, -1, failure);
    }

    ProcessResultImpl(List<String> command, int exitValue, Throwable failure) {
        this.mCommand = ImmutableList.copyOf(command);
        this.mExitValue = exitValue;
        this.mFailure = failure;
    }

    @Override
    public ProcessResult assertNormalExitValue() throws ProcessException {
        if (this.mExitValue != 0) {
            throw new ProcessException(String.format("Return code %d for process '%s'", this.mExitValue, Joiner.on(" ").join(this.mCommand)));
        }
        return this;
    }

    @Override
    public int getExitValue() {
        return this.mExitValue;
    }

    @Override
    public ProcessResult rethrowFailure() throws ProcessException {
        if (this.mFailure != null) {
            throw new ProcessException("", this.mFailure);
        }
        return this;
    }
}

