/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeModel;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

public final class IdeModuleLibrary
implements Library,
Serializable {
    private static final long serialVersionUID = 5L;
    private final String myArtifactAddress;
    private final String myBuildId;
    private final String myProjectPath;
    private final String myVariant;
    private final int myType;
    private final int myHashCode;

    public IdeModuleLibrary() {
        this.myArtifactAddress = "";
        this.myBuildId = null;
        this.myProjectPath = null;
        this.myVariant = null;
        this.myType = 0;
        this.myHashCode = 0;
    }

    IdeModuleLibrary(Library library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(library::getBuildId, null);
        this.myProjectPath = IdeModel.copyNewProperty(library::getProjectPath, null);
        this.myVariant = IdeModel.copyNewProperty(library::getVariant, null);
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(AndroidLibrary library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(library::getBuildId, null);
        this.myProjectPath = IdeModel.copyNewProperty(library::getProject, null);
        this.myVariant = IdeModel.copyNewProperty(library::getProjectVariant, null);
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(JavaLibrary library, String artifactAddress) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = IdeModel.copyNewProperty(library::getBuildId, null);
        this.myProjectPath = IdeModel.copyNewProperty(library::getProject, null);
        this.myVariant = null;
        this.myHashCode = this.calculateHashCode();
    }

    IdeModuleLibrary(String projectPath, String artifactAddress, String buildId) {
        this.myType = 3;
        this.myArtifactAddress = artifactAddress;
        this.myBuildId = buildId;
        this.myProjectPath = projectPath;
        this.myVariant = null;
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public int getType() {
        return this.myType;
    }

    @Override
    public String getArtifactAddress() {
        return this.myArtifactAddress;
    }

    @Override
    public File getArtifact() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getArtifact()");
    }

    @Override
    public String getBuildId() {
        return this.myBuildId;
    }

    @Override
    public String getProjectPath() {
        return this.myProjectPath;
    }

    @Override
    public String getVariant() {
        return this.myVariant;
    }

    @Override
    public File getFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getFolder");
    }

    @Override
    public String getManifest() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getManifest");
    }

    @Override
    public String getJarFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getJarFile");
    }

    @Override
    public String getCompileJarFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getCompileJarFile");
    }

    @Override
    public String getResFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getResFolder");
    }

    @Override
    public File getResStaticLibrary() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getResStaticLibrary");
    }

    @Override
    public String getAssetsFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getAssetsFolder");
    }

    @Override
    public Collection<String> getLocalJars() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getLocalJars");
    }

    @Override
    public String getJniFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getJniFolder");
    }

    @Override
    public String getAidlFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getAidlFolder");
    }

    @Override
    public String getRenderscriptFolder() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getRenderscriptFolder");
    }

    @Override
    public String getProguardRules() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getProguardRules");
    }

    @Override
    public String getLintJar() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getLintJar");
    }

    @Override
    public String getExternalAnnotations() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getExternalAnnotations");
    }

    @Override
    public String getPublicResources() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getPublicResources");
    }

    @Override
    public String getSymbolFile() {
        throw IdeModuleLibrary.unsupportedMethodForModuleLibrary("getSymbolFile");
    }

    private static UnsupportedOperationException unsupportedMethodForModuleLibrary(String methodName) {
        return new UnsupportedOperationException(methodName + "() cannot be called when getType() returns LIBRARY_MODULE");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeModuleLibrary)) {
            return false;
        }
        IdeModuleLibrary that = (IdeModuleLibrary)o;
        return this.myType == that.myType && Objects.equals(this.myArtifactAddress, that.myArtifactAddress) && Objects.equals(this.myProjectPath, that.myProjectPath) && Objects.equals(this.myBuildId, that.myBuildId) && Objects.equals(this.myVariant, that.myVariant);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myType, this.myArtifactAddress, this.myBuildId, this.myProjectPath, this.myVariant);
    }

    public String toString() {
        return "IdeModuleLibrary{myType=" + this.myType + ", myArtifactAddress='" + this.myArtifactAddress + '\'' + ", myBuildId='" + this.myBuildId + '\'' + ", myProjectPath='" + this.myProjectPath + '\'' + ", myVariant='" + this.myVariant + '\'' + '}';
    }
}

