/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.ide.common.gradle.model.IdeFilterData;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeOutputFile;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class IdeVariantOutput
implements VariantOutput,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Collection<? extends OutputFile> myOutputs;
    private final Collection<String> myFilterTypes;
    private final Collection<FilterData> myFilters;
    private final OutputFile myMainOutputFile;
    private final String myOutputType;
    private final int myVersionCode;
    private final int hashCode;

    IdeVariantOutput() {
        this.myOutputs = Collections.emptyList();
        this.myFilterTypes = Collections.emptyList();
        this.myFilters = null;
        this.myMainOutputFile = null;
        this.myOutputType = null;
        this.myVersionCode = 0;
        this.hashCode = 0;
    }

    public IdeVariantOutput(VariantOutput output, ModelCache modelCache) {
        this.myOutputs = IdeModel.copy(output.getOutputs(), modelCache, outputFile -> new IdeOutputFile((OutputFile)outputFile, modelCache));
        this.myFilterTypes = IdeModel.copyNewProperty(() -> ImmutableList.copyOf(output.getFilterTypes()), Collections.emptyList());
        this.myFilters = IdeVariantOutput.copyFilters(output, modelCache);
        this.myMainOutputFile = IdeModel.copyNewProperty(modelCache, output::getMainOutputFile, file -> new IdeOutputFile((OutputFile)file, modelCache), null);
        this.myOutputType = IdeModel.copyNewProperty(output::getOutputType, null);
        this.myVersionCode = output.getVersionCode();
        this.hashCode = this.calculateHashCode();
    }

    private static Collection<FilterData> copyFilters(VariantOutput output, ModelCache modelCache) {
        try {
            return IdeModel.copy(output.getFilters(), modelCache, data2 -> new IdeFilterData((FilterData)data2));
        }
        catch (UnsupportedOperationException ignored) {
            return null;
        }
    }

    @Override
    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            return this.myMainOutputFile;
        }
        throw new UnsupportedOperationException("getMainOutputFile()");
    }

    @Override
    public Collection<? extends OutputFile> getOutputs() {
        return this.myOutputs;
    }

    @Override
    public String getOutputType() {
        if (this.myOutputType != null) {
            return this.myOutputType;
        }
        throw new UnsupportedOperationException("getOutputType");
    }

    @Override
    public Collection<String> getFilterTypes() {
        return this.myFilterTypes;
    }

    @Override
    public Collection<FilterData> getFilters() {
        if (this.myFilters != null) {
            return this.myFilters;
        }
        throw new UnsupportedOperationException("getFilters");
    }

    @Override
    public int getVersionCode() {
        return this.myVersionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVariantOutput)) {
            return false;
        }
        IdeVariantOutput output = (IdeVariantOutput)o;
        return output.canEquals(this) && this.myVersionCode == output.myVersionCode && Objects.equals(this.myMainOutputFile, output.myMainOutputFile) && Objects.equals(this.myOutputs, output.myOutputs) && Objects.equals(this.myOutputType, output.myOutputType) && Objects.equals(this.myFilterTypes, output.myFilterTypes) && Objects.equals(this.myFilters, output.myFilters);
    }

    protected boolean canEquals(Object other) {
        return other instanceof IdeVariantOutput;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myMainOutputFile, this.myOutputs, this.myOutputType, this.myFilterTypes, this.myFilters, this.myVersionCode);
    }

    public String toString() {
        return "myMainOutputFile=" + this.myMainOutputFile + ", myOutputs=" + this.myOutputs + ", myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myVersionCode=" + this.myVersionCode;
    }
}

