/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.SigningConfig;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public final class IdeSigningConfig
implements SigningConfig,
Serializable {
    private static final long serialVersionUID = 3L;
    private final String myName;
    private final File myStoreFile;
    private final String myStorePassword;
    private final String myKeyAlias;
    private final Boolean myV1SigningEnabled;
    private final int myHashCode;

    IdeSigningConfig() {
        this.myName = "";
        this.myStoreFile = null;
        this.myStorePassword = null;
        this.myKeyAlias = null;
        this.myV1SigningEnabled = null;
        this.myHashCode = 0;
    }

    public IdeSigningConfig(SigningConfig config) {
        this.myName = config.getName();
        this.myStoreFile = config.getStoreFile();
        this.myStorePassword = config.getStorePassword();
        this.myKeyAlias = config.getKeyAlias();
        this.myV1SigningEnabled = IdeModel.copyNewProperty(config::isV1SigningEnabled, null);
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public File getStoreFile() {
        return this.myStoreFile;
    }

    @Override
    public String getStorePassword() {
        return this.myStorePassword;
    }

    @Override
    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    @Override
    public String getKeyPassword() {
        throw new UnusedModelMethodException("getKeyPassword");
    }

    @Override
    public String getStoreType() {
        throw new UnusedModelMethodException("getStoreType");
    }

    @Override
    public boolean isV1SigningEnabled() {
        if (this.myV1SigningEnabled != null) {
            return this.myV1SigningEnabled;
        }
        throw new UnsupportedOperationException("Unsupported method: SigningConfig.isV1SigningEnabled()");
    }

    @Override
    public boolean isV2SigningEnabled() {
        throw new UnusedModelMethodException("isV2SigningEnabled");
    }

    @Override
    public boolean isSigningReady() {
        throw new UnusedModelMethodException("isSigningReady");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSigningConfig)) {
            return false;
        }
        IdeSigningConfig config = (IdeSigningConfig)o;
        return Objects.equals(this.myV1SigningEnabled, config.myV1SigningEnabled) && Objects.equals(this.myName, config.myName) && Objects.equals(this.myStoreFile, config.myStoreFile) && Objects.equals(this.myStorePassword, config.myStorePassword) && Objects.equals(this.myKeyAlias, config.myKeyAlias);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myStoreFile, this.myStorePassword, this.myKeyAlias, this.myV1SigningEnabled);
    }

    public String toString() {
        return "IdeSigningConfig{myName='" + this.myName + '\'' + ", myStoreFile=" + this.myStoreFile + ", myStorePassword='" + this.myStorePassword + '\'' + ", myKeyAlias='" + this.myKeyAlias + '\'' + ", myV1SigningEnabled=" + this.myV1SigningEnabled + '}';
    }
}

