/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeSettings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeNativeSettings
implements NativeSettings,
Serializable {
    private final String myName;
    private final List<String> myCompilerFlags;
    private final int myHashCode;

    public IdeNativeSettings() {
        this.myName = "";
        this.myCompilerFlags = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeNativeSettings(NativeSettings settings2) {
        this.myName = settings2.getName();
        List<String> compilerFlags = settings2.getCompilerFlags();
        this.myCompilerFlags = compilerFlags != null && !compilerFlags.isEmpty() ? ImmutableList.copyOf(compilerFlags) : Collections.emptyList();
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public List<String> getCompilerFlags() {
        return this.myCompilerFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeSettings)) {
            return false;
        }
        IdeNativeSettings settings2 = (IdeNativeSettings)o;
        return Objects.equals(this.myName, settings2.myName) && Objects.equals(this.myCompilerFlags, settings2.myCompilerFlags);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myCompilerFlags);
    }

    public String toString() {
        return "IdeNativeSettings{myName='" + this.myName + '\'' + ", myCompilerFlags=" + this.myCompilerFlags + "}";
    }
}

