/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeLibrary;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeNativeLibrary
implements NativeLibrary,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myName;
    private final String myAbi;
    private final String myToolchainName;
    private final List<File> myCIncludeDirs;
    private final List<File> myCppIncludeDirs;
    private final List<File> myCSystemIncludeDirs;
    private final List<File> myCppSystemIncludeDirs;
    private final List<String> myCDefines;
    private final List<String> myCppDefines;
    private final List<String> myCCompilerFlags;
    private final List<String> myCppCompilerFlags;
    private final List<File> myDebuggableLibraryFolders;
    private final int myHashCode;

    public IdeNativeLibrary() {
        this.myName = "";
        this.myAbi = "";
        this.myToolchainName = "";
        this.myCIncludeDirs = Collections.emptyList();
        this.myCppCompilerFlags = Collections.emptyList();
        this.myCSystemIncludeDirs = Collections.emptyList();
        this.myCppIncludeDirs = Collections.emptyList();
        this.myCppSystemIncludeDirs = Collections.emptyList();
        this.myCDefines = Collections.emptyList();
        this.myCppDefines = Collections.emptyList();
        this.myCCompilerFlags = Collections.emptyList();
        this.myDebuggableLibraryFolders = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeNativeLibrary(NativeLibrary library) {
        this.myName = library.getName();
        this.myAbi = library.getAbi();
        this.myToolchainName = library.getToolchainName();
        this.myCIncludeDirs = ImmutableList.copyOf(library.getCIncludeDirs());
        this.myCppIncludeDirs = ImmutableList.copyOf(library.getCppIncludeDirs());
        this.myCSystemIncludeDirs = ImmutableList.copyOf(library.getCSystemIncludeDirs());
        this.myCppSystemIncludeDirs = ImmutableList.copyOf(library.getCppSystemIncludeDirs());
        this.myCDefines = ImmutableList.copyOf(library.getCDefines());
        this.myCppDefines = ImmutableList.copyOf(library.getCppDefines());
        this.myCCompilerFlags = ImmutableList.copyOf(library.getCCompilerFlags());
        this.myCppCompilerFlags = ImmutableList.copyOf(library.getCppCompilerFlags());
        this.myDebuggableLibraryFolders = ImmutableList.copyOf(library.getDebuggableLibraryFolders());
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getAbi() {
        return this.myAbi;
    }

    @Override
    public String getToolchainName() {
        return this.myToolchainName;
    }

    @Override
    public List<File> getCIncludeDirs() {
        return this.myCIncludeDirs;
    }

    @Override
    public List<File> getCppIncludeDirs() {
        return this.myCppIncludeDirs;
    }

    @Override
    public List<File> getCSystemIncludeDirs() {
        return this.myCSystemIncludeDirs;
    }

    @Override
    public List<File> getCppSystemIncludeDirs() {
        return this.myCppSystemIncludeDirs;
    }

    @Override
    public List<String> getCDefines() {
        return this.myCDefines;
    }

    @Override
    public List<String> getCppDefines() {
        return this.myCppDefines;
    }

    @Override
    public List<String> getCCompilerFlags() {
        return this.myCCompilerFlags;
    }

    @Override
    public List<String> getCppCompilerFlags() {
        return this.myCppCompilerFlags;
    }

    @Override
    public List<File> getDebuggableLibraryFolders() {
        return this.myDebuggableLibraryFolders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeLibrary)) {
            return false;
        }
        IdeNativeLibrary library = (IdeNativeLibrary)o;
        return Objects.equals(this.myName, library.myName) && Objects.equals(this.myAbi, library.myAbi) && Objects.equals(this.myToolchainName, library.myToolchainName) && Objects.equals(this.myCIncludeDirs, library.myCIncludeDirs) && Objects.equals(this.myCppIncludeDirs, library.myCppIncludeDirs) && Objects.equals(this.myCSystemIncludeDirs, library.myCSystemIncludeDirs) && Objects.equals(this.myCppSystemIncludeDirs, library.myCppSystemIncludeDirs) && Objects.equals(this.myCDefines, library.myCDefines) && Objects.equals(this.myCppDefines, library.myCppDefines) && Objects.equals(this.myCCompilerFlags, library.myCCompilerFlags) && Objects.equals(this.myCppCompilerFlags, library.myCppCompilerFlags) && Objects.equals(this.myDebuggableLibraryFolders, library.myDebuggableLibraryFolders);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myAbi, this.myToolchainName, this.myCIncludeDirs, this.myCppIncludeDirs, this.myCSystemIncludeDirs, this.myCppSystemIncludeDirs, this.myCDefines, this.myCppDefines, this.myCCompilerFlags, this.myCppCompilerFlags, this.myDebuggableLibraryFolders);
    }

    public String toString() {
        return "IdeNativeLibrary{myName='" + this.myName + '\'' + ", myAbi='" + this.myAbi + '\'' + ", myToolchainName='" + this.myToolchainName + '\'' + ", myCIncludeDirs=" + this.myCIncludeDirs + ", myCppIncludeDirs=" + this.myCppIncludeDirs + ", myCSystemIncludeDirs=" + this.myCSystemIncludeDirs + ", myCppSystemIncludeDirs=" + this.myCppSystemIncludeDirs + ", myCDefines=" + this.myCDefines + ", myCppDefines=" + this.myCppDefines + ", myCCompilerFlags=" + this.myCCompilerFlags + ", myCppCompilerFlags=" + this.myCppCompilerFlags + ", myDebuggableLibraryFolders=" + this.myDebuggableLibraryFolders + "}";
    }
}

