/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantInfo;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeArtifact;
import com.android.ide.common.gradle.model.IdeNativeSettings;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.IdeNativeVariantInfo;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IdeNativeAndroidProjectImpl
implements IdeNativeAndroidProject,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myModelVersion;
    private final String myName;
    private final List<File> myBuildFiles;
    private final Map<String, NativeVariantInfo> myVariantInfos;
    private final Collection<NativeArtifact> myArtifacts;
    private final Collection<NativeToolchain> myToolChains;
    private final Collection<NativeSettings> mySettings;
    private final Map<String, String> myFileExtensions;
    private final Collection<String> myBuildSystems;
    private final String myDefaultNdkVersion;
    private final int myApiVersion;
    private final int myHashCode;

    public IdeNativeAndroidProjectImpl() {
        this.myModelVersion = "";
        this.myName = "";
        this.myBuildFiles = Collections.emptyList();
        this.myVariantInfos = Collections.emptyMap();
        this.myArtifacts = Collections.emptyList();
        this.myToolChains = Collections.emptyList();
        this.mySettings = Collections.emptyList();
        this.myFileExtensions = Collections.emptyMap();
        this.myBuildSystems = Collections.emptyList();
        this.myDefaultNdkVersion = "";
        this.myApiVersion = 0;
        this.myHashCode = 0;
    }

    public IdeNativeAndroidProjectImpl(NativeAndroidProject project) {
        this(project, new ModelCache());
    }

    @VisibleForTesting
    IdeNativeAndroidProjectImpl(NativeAndroidProject project, ModelCache modelCache) {
        this.myModelVersion = project.getModelVersion();
        this.myApiVersion = project.getApiVersion();
        this.myName = project.getName();
        this.myBuildFiles = ImmutableList.copyOf(project.getBuildFiles());
        this.myVariantInfos = IdeNativeAndroidProjectImpl.copyVariantInfos(project, modelCache);
        this.myArtifacts = IdeModel.copy(project.getArtifacts(), modelCache, artifact -> new IdeNativeArtifact((NativeArtifact)artifact, modelCache));
        this.myToolChains = IdeModel.copy(project.getToolChains(), modelCache, toolchain -> new IdeNativeToolchain((NativeToolchain)toolchain));
        this.mySettings = IdeModel.copy(project.getSettings(), modelCache, settings2 -> new IdeNativeSettings((NativeSettings)settings2));
        this.myFileExtensions = ImmutableMap.copyOf(project.getFileExtensions());
        this.myDefaultNdkVersion = IdeNativeAndroidProjectImpl.copyDefaultNdkVersion(project);
        this.myBuildSystems = IdeNativeAndroidProjectImpl.copyBuildSystems(project);
        this.myHashCode = this.calculateHashCode();
    }

    private static Map<String, NativeVariantInfo> copyVariantInfos(NativeAndroidProject project, ModelCache modelCache) {
        try {
            return IdeModel.copy(project.getVariantInfos(), modelCache, variantInfo -> new IdeNativeVariantInfo(variantInfo.getAbiNames(), Objects.requireNonNull(IdeModel.copyNewProperty(() -> variantInfo.getBuildRootFolderMap(), Collections.emptyMap()))));
        }
        catch (UnsupportedOperationException e) {
            return Maps.newHashMap();
        }
    }

    private static String copyDefaultNdkVersion(NativeAndroidProject project) {
        try {
            return project.getDefaultNdkVersion();
        }
        catch (UnsupportedOperationException e) {
            return "";
        }
    }

    private static Collection<String> copyBuildSystems(NativeAndroidProject project) {
        try {
            return ImmutableList.copyOf(project.getBuildSystems());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public String getModelVersion() {
        return this.myModelVersion;
    }

    @Override
    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Map<String, NativeVariantInfo> getVariantInfos() {
        return this.myVariantInfos;
    }

    @Override
    public Collection<File> getBuildFiles() {
        return this.myBuildFiles;
    }

    @Override
    public Collection<NativeArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    @Override
    public Collection<NativeToolchain> getToolChains() {
        return this.myToolChains;
    }

    @Override
    public Collection<NativeSettings> getSettings() {
        return this.mySettings;
    }

    @Override
    public Map<String, String> getFileExtensions() {
        return this.myFileExtensions;
    }

    @Override
    public Collection<String> getBuildSystems() {
        if (this.myBuildSystems != null) {
            return this.myBuildSystems;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeAndroidProject.getBuildSystems()");
    }

    @Override
    public String getDefaultNdkVersion() {
        if (this.myDefaultNdkVersion != null) {
            return this.myDefaultNdkVersion;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeAndroidProject.getDefaultNdkVersion()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeAndroidProjectImpl)) {
            return false;
        }
        IdeNativeAndroidProjectImpl project = (IdeNativeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myBuildFiles, project.myBuildFiles) && Objects.equals(this.myVariantInfos, project.myVariantInfos) && Objects.equals(this.myArtifacts, project.myArtifacts) && Objects.equals(this.myToolChains, project.myToolChains) && Objects.equals(this.mySettings, project.mySettings) && Objects.equals(this.myFileExtensions, project.myFileExtensions) && Objects.equals(this.myBuildSystems, project.myBuildSystems) && Objects.equals(this.myDefaultNdkVersion, project.myDefaultNdkVersion);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myName, this.myBuildFiles, this.myVariantInfos, this.myArtifacts, this.myToolChains, this.mySettings, this.myFileExtensions, this.myBuildSystems, this.myApiVersion, this.myDefaultNdkVersion);
    }

    public String toString() {
        return "IdeNativeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myBuildFiles=" + this.myBuildFiles + ", myArtifacts=" + this.myArtifacts + ", myToolChains=" + this.myToolChains + ", mySettings=" + this.mySettings + ", myFileExtensions=" + this.myFileExtensions + ", myBuildSystems=" + this.myBuildSystems + ", myApiVersion=" + this.myApiVersion + ", myDefaultNdkVersion=" + this.myDefaultNdkVersion + "}";
    }

    public static class FactoryImpl
    implements IdeNativeAndroidProject.Factory {
        @Override
        public IdeNativeAndroidProject create(NativeAndroidProject project) {
            return new IdeNativeAndroidProjectImpl(project);
        }
    }
}

