/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class IdeModel {
    public static <K, V> V copyNewProperty(ModelCache modelCache, Supplier<K> keyCreator, Function<K, V> mapper, V defaultValue) {
        try {
            K key = keyCreator.get();
            return key != null ? modelCache.computeIfAbsent(key, mapper) : defaultValue;
        }
        catch (UnsupportedOperationException ignored) {
            return defaultValue;
        }
    }

    public static <T> T copyNewProperty(Supplier<? extends T> propertyInvoker, T defaultValue) {
        try {
            return propertyInvoker.get();
        }
        catch (UnsupportedOperationException ignored) {
            return defaultValue;
        }
    }

    public static <T> T copyNewPropertyNonNull(Supplier<? extends T> propertyInvoker, T defaultValue) {
        try {
            return propertyInvoker.get();
        }
        catch (UnsupportedOperationException ignored) {
            return defaultValue;
        }
    }

    public static <T> T copyNewPropertyWithDefault(Supplier<T> propertyInvoker, Supplier<T> defaultValue) {
        try {
            return propertyInvoker.get();
        }
        catch (UnsupportedOperationException ignored) {
            return defaultValue.get();
        }
    }

    public static <K, V> List<V> copy(Collection<K> original, ModelCache modelCache, Function<K, V> mapper) {
        if (original.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder copies = ImmutableList.builder();
        for (K item : original) {
            V copy2 = modelCache.computeIfAbsent(item, mapper);
            copies.add(copy2);
        }
        return copies.build();
    }

    public static <K, V> List<V> copy(Supplier<Collection<K>> propertyInvoker, ModelCache modelCache, Function<K, V> mapper) {
        try {
            return IdeModel.copy(propertyInvoker.get(), modelCache, mapper);
        }
        catch (UnsupportedOperationException ignored) {
            return Collections.emptyList();
        }
    }

    public static <K, V> Map<K, V> copy(Map<K, V> original, ModelCache modelCache, Function<V, V> mapper) {
        if (original.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder copies = ImmutableMap.builder();
        original.forEach((k, v) -> {
            Object copy2 = modelCache.computeIfAbsent(v, mapper);
            copies.put(k, copy2);
        });
        return copies.build();
    }

    public static Set<String> copy(Set<String> original) {
        return original != null ? ImmutableSet.copyOf(original) : null;
    }
}

