/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public final class IdeMavenCoordinates
implements MavenCoordinates,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final String LOCAL_AARS = "__local_aars__";
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPacking;
    private final String myClassifier;
    private final int myHashCode;

    IdeMavenCoordinates() {
        this.myGroupId = "";
        this.myArtifactId = "";
        this.myVersion = "";
        this.myPacking = "";
        this.myClassifier = null;
        this.myHashCode = 0;
    }

    public IdeMavenCoordinates(MavenCoordinates coordinates) {
        this.myGroupId = coordinates.getGroupId();
        this.myArtifactId = coordinates.getArtifactId();
        this.myVersion = coordinates.getVersion();
        this.myPacking = coordinates.getPackaging();
        this.myClassifier = coordinates.getClassifier();
        this.myHashCode = this.calculateHashCode();
    }

    public IdeMavenCoordinates(File localJar) {
        this.myGroupId = LOCAL_AARS;
        this.myArtifactId = localJar.getPath();
        this.myVersion = "unspecified";
        this.myPacking = "jar";
        this.myClassifier = null;
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getPackaging() {
        return this.myPacking;
    }

    @Override
    public String getClassifier() {
        return this.myClassifier;
    }

    @Override
    public String getVersionlessId() {
        throw new UnusedModelMethodException("getVersionlessId");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeMavenCoordinates)) {
            return false;
        }
        IdeMavenCoordinates that = (IdeMavenCoordinates)o;
        return Objects.equals(this.myGroupId, that.myGroupId) && Objects.equals(this.myArtifactId, that.myArtifactId) && Objects.equals(this.myVersion, that.myVersion) && Objects.equals(this.myPacking, that.myPacking) && Objects.equals(this.myClassifier, that.myClassifier);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myGroupId, this.myArtifactId, this.myVersion, this.myPacking, this.myClassifier);
    }

    public String toString() {
        return "IdeMavenCoordinates{myGroupId='" + this.myGroupId + '\'' + ", myArtifactId='" + this.myArtifactId + '\'' + ", myVersion='" + this.myVersion + '\'' + ", myPacking='" + this.myPacking + '\'' + ", myClassifier='" + this.myClassifier + '\'' + '}';
    }
}

