/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.Library;
import com.android.ide.common.gradle.model.IdeLibraries;
import com.android.ide.common.gradle.model.IdeMavenCoordinates;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.Serializable;
import java.util.Objects;

public abstract class IdeLibrary
implements Library,
Serializable {
    private static final long serialVersionUID = 4L;
    private final IdeMavenCoordinates myResolvedCoordinates;
    private final IdeMavenCoordinates myRequestedCoordinates;
    private final String myBuildId;
    private final String myProject;
    private final String myName;
    private final Boolean myIsSkipped;
    private final Boolean myProvided;
    private final int hashCode;

    IdeLibrary() {
        this.myResolvedCoordinates = new IdeMavenCoordinates();
        this.myRequestedCoordinates = new IdeMavenCoordinates();
        this.myBuildId = null;
        this.myProject = null;
        this.myName = null;
        this.myIsSkipped = null;
        this.myProvided = null;
        this.hashCode = 0;
    }

    protected IdeLibrary(Library library, ModelCache modelCache) {
        this.myResolvedCoordinates = IdeLibraries.computeResolvedCoordinate(library, modelCache);
        this.myRequestedCoordinates = IdeLibraries.computeRequestedCoordinate(library);
        this.myBuildId = IdeModel.copyNewProperty(library::getBuildId, null);
        this.myProject = IdeModel.copyNewProperty(library::getProject, null);
        this.myName = IdeModel.copyNewProperty(library::getName, null);
        this.myProvided = IdeModel.copyNewProperty(library::isProvided, false);
        this.myIsSkipped = IdeModel.copyNewProperty(library::isSkipped, false);
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public IdeMavenCoordinates getRequestedCoordinates() {
        return this.myRequestedCoordinates;
    }

    @Override
    public IdeMavenCoordinates getResolvedCoordinates() {
        return this.myResolvedCoordinates;
    }

    @Override
    public String getBuildId() {
        return this.myBuildId;
    }

    @Override
    public String getProject() {
        return this.myProject;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isSkipped() {
        if (this.myIsSkipped != null) {
            return this.myIsSkipped;
        }
        throw new UnsupportedOperationException("Unsupported method: IdeLibrary.isSkipped()");
    }

    @Override
    public boolean isProvided() {
        if (this.myProvided != null) {
            return this.myProvided;
        }
        throw new UnsupportedOperationException("Unsupported method: IdeLibrary.isProvided()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeLibrary)) {
            return false;
        }
        IdeLibrary library = (IdeLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myIsSkipped, library.myIsSkipped) && Objects.equals(this.myProvided, library.myProvided) && Objects.equals(this.myResolvedCoordinates, library.myResolvedCoordinates) && Objects.equals(this.myRequestedCoordinates, library.myRequestedCoordinates) && Objects.equals(this.myBuildId, library.myBuildId) && Objects.equals(this.myProject, library.myProject) && Objects.equals(this.myName, library.myName);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeLibrary;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myResolvedCoordinates, this.myRequestedCoordinates, this.myBuildId, this.myProject, this.myName, this.myProvided, this.myIsSkipped);
    }

    public String toString() {
        return "myResolvedCoordinates=" + this.myResolvedCoordinates + ", myRequestedCoordinates='" + this.myRequestedCoordinates + ", myBuildId='" + this.myBuildId + '\'' + ", myProject='" + this.myProject + '\'' + ", myName='" + this.myName + '\'' + ", myProvided=" + this.myProvided;
    }
}

