/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.InstantRun;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public final class IdeInstantRun
implements InstantRun,
Serializable {
    private static final long serialVersionUID = 2L;
    private final File myInfoFile;
    private final boolean mySupportedByArtifact;
    private final int mySupportStatus;
    private final int myHashCode;

    IdeInstantRun() {
        this.myInfoFile = null;
        this.mySupportedByArtifact = false;
        this.mySupportStatus = 0;
        this.myHashCode = 0;
    }

    public IdeInstantRun(InstantRun run) {
        this.myInfoFile = run.getInfoFile();
        this.mySupportedByArtifact = run.isSupportedByArtifact();
        this.mySupportStatus = run.getSupportStatus();
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public File getInfoFile() {
        return this.myInfoFile;
    }

    @Override
    public boolean isSupportedByArtifact() {
        return this.mySupportedByArtifact;
    }

    @Override
    public int getSupportStatus() {
        return this.mySupportStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeInstantRun)) {
            return false;
        }
        IdeInstantRun run = (IdeInstantRun)o;
        return this.mySupportedByArtifact == run.mySupportedByArtifact && this.mySupportStatus == run.mySupportStatus && Objects.equals(this.myInfoFile, run.myInfoFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myInfoFile, this.mySupportedByArtifact, this.mySupportStatus);
    }

    public String toString() {
        return "IdeInstantRun{myInfoFile=" + this.myInfoFile + ", mySupportedByArtifact=" + this.mySupportedByArtifact + ", mySupportStatus=" + this.mySupportStatus + "}";
    }
}

