/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Objects;

public final class IdeFilterData
implements FilterData,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myIdentifier;
    private final String myFilterType;
    private final int myHashCode;

    @VisibleForTesting
    public IdeFilterData() {
        this.myIdentifier = "";
        this.myFilterType = "";
        this.myHashCode = 0;
    }

    public IdeFilterData(FilterData data2) {
        this.myIdentifier = data2.getIdentifier();
        this.myFilterType = data2.getFilterType();
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getIdentifier() {
        return this.myIdentifier;
    }

    @Override
    public String getFilterType() {
        return this.myFilterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeFilterData)) {
            return false;
        }
        IdeFilterData data2 = (IdeFilterData)o;
        return Objects.equals(this.myIdentifier, data2.myIdentifier) && Objects.equals(this.myFilterType, data2.myFilterType);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myIdentifier, this.myFilterType);
    }

    public String toString() {
        return "IdeFilterData{myIdentifier='" + this.myIdentifier + '\'' + ", myFilterType='" + this.myFilterType + '\'' + "}";
    }
}

