/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.ide.common.gradle.model.IdeGraphItem;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeDependencyGraphs
implements DependencyGraphs,
Serializable {
    private static final long serialVersionUID = 2L;
    private final List<GraphItem> myCompileDependencies;
    private final List<GraphItem> myPackageDependencies;
    private final List<String> myProvidedLibraries;
    private final List<String> mySkippedLibraries;
    private final int myHashCode;

    IdeDependencyGraphs() {
        this.myCompileDependencies = Collections.emptyList();
        this.myPackageDependencies = Collections.emptyList();
        this.myProvidedLibraries = Collections.emptyList();
        this.mySkippedLibraries = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeDependencyGraphs(DependencyGraphs graphs, ModelCache modelCache) {
        this.myCompileDependencies = IdeModel.copy(graphs.getCompileDependencies(), modelCache, item -> new IdeGraphItem((GraphItem)item, modelCache));
        this.myPackageDependencies = IdeModel.copy(graphs.getPackageDependencies(), modelCache, item -> new IdeGraphItem((GraphItem)item, modelCache));
        this.myProvidedLibraries = ImmutableList.copyOf(graphs.getProvidedLibraries());
        this.mySkippedLibraries = ImmutableList.copyOf(graphs.getSkippedLibraries());
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public List<GraphItem> getCompileDependencies() {
        return this.myCompileDependencies;
    }

    @Override
    public List<GraphItem> getPackageDependencies() {
        return this.myPackageDependencies;
    }

    @Override
    public List<String> getProvidedLibraries() {
        return this.myProvidedLibraries;
    }

    @Override
    public List<String> getSkippedLibraries() {
        return this.mySkippedLibraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependencyGraphs)) {
            return false;
        }
        IdeDependencyGraphs graphs = (IdeDependencyGraphs)o;
        return Objects.equals(this.myCompileDependencies, graphs.myCompileDependencies) && Objects.equals(this.myPackageDependencies, graphs.myPackageDependencies) && Objects.equals(this.myProvidedLibraries, graphs.myProvidedLibraries) && Objects.equals(this.mySkippedLibraries, graphs.mySkippedLibraries);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myCompileDependencies, this.myPackageDependencies, this.myProvidedLibraries, this.mySkippedLibraries);
    }

    public String toString() {
        return "IdeDependencyGraphs{myCompileDependencies=" + this.myCompileDependencies + ", myPackageDependencies=" + this.myPackageDependencies + ", myProvidedLibraries=" + this.myProvidedLibraries + ", mySkippedLibraries=" + this.mySkippedLibraries + '}';
    }
}

