/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.ide.common.gradle.model.IdeAndroidLibrary;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaLibrary;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeProjectIdentifierImpl;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;

public final class IdeDependenciesImpl
implements IdeDependencies,
Serializable {
    private static final long serialVersionUID = 4L;
    private final Collection<AndroidLibrary> myLibraries;
    private final Collection<JavaLibrary> myJavaLibraries;
    private final Collection<String> myProjects;
    private final Collection<Dependencies.ProjectIdentifier> myJavaModules;
    private final Collection<File> myRuntimeOnlyClasses;
    private final int myHashCode;

    IdeDependenciesImpl() {
        this.myLibraries = Collections.emptyList();
        this.myJavaLibraries = Collections.emptyList();
        this.myProjects = Collections.emptyList();
        this.myJavaModules = Collections.emptyList();
        this.myRuntimeOnlyClasses = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeDependenciesImpl(Dependencies dependencies, ModelCache modelCache) {
        this.myLibraries = IdeModel.copy(dependencies.getLibraries(), modelCache, library -> new IdeAndroidLibrary((AndroidLibrary)library, modelCache));
        this.myJavaLibraries = IdeModel.copy(dependencies.getJavaLibraries(), modelCache, library -> new IdeJavaLibrary((JavaLibrary)library, modelCache));
        this.myProjects = ImmutableList.copyOf(dependencies.getProjects());
        this.myJavaModules = IdeModel.copy(dependencies::getJavaModules, modelCache, projectId -> new IdeProjectIdentifierImpl((Dependencies.ProjectIdentifier)projectId));
        this.myRuntimeOnlyClasses = ImmutableList.copyOf(Objects.requireNonNull(IdeModel.copyNewProperty(dependencies::getRuntimeOnlyClasses, Collections.emptyList())));
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public Collection<AndroidLibrary> getLibraries() {
        return this.myLibraries;
    }

    @Override
    public Collection<JavaLibrary> getJavaLibraries() {
        return this.myJavaLibraries;
    }

    @Override
    public Collection<String> getProjects() {
        return this.myProjects;
    }

    @Override
    public Collection<Dependencies.ProjectIdentifier> getJavaModules() {
        return this.myJavaModules;
    }

    @Override
    public Collection<File> getRuntimeOnlyClasses() {
        return this.myRuntimeOnlyClasses;
    }

    @Override
    public void forEachLibrary(Consumer<IdeAndroidLibrary> action) {
        for (AndroidLibrary library : this.myLibraries) {
            action.accept((IdeAndroidLibrary)library);
        }
    }

    @Override
    public void forEachJavaLibrary(Consumer<IdeJavaLibrary> action) {
        for (JavaLibrary library : this.myJavaLibraries) {
            action.accept((IdeJavaLibrary)library);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependenciesImpl)) {
            return false;
        }
        IdeDependenciesImpl that = (IdeDependenciesImpl)o;
        return Objects.equals(this.myLibraries, that.myLibraries) && Objects.equals(this.myJavaLibraries, that.myJavaLibraries) && Objects.equals(this.myProjects, that.myProjects) && Objects.equals(this.myJavaModules, that.myJavaModules) && Objects.equals(this.myRuntimeOnlyClasses, that.myRuntimeOnlyClasses);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myLibraries, this.myJavaLibraries, this.myProjects, this.myJavaModules, this.myRuntimeOnlyClasses);
    }

    public String toString() {
        return "IdeDependencies{myLibraries=" + this.myLibraries + ", myJavaLibraries=" + this.myJavaLibraries + ", myProjects=" + this.myProjects + ", myJavaModules=" + this.myJavaModules + ", myRuntimeOnlyClasses=" + this.myRuntimeOnlyClasses + '}';
    }
}

