/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.android.ide.common.gradle.model.IdeClassField;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public abstract class IdeBaseConfig
implements BaseConfig,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myName;
    private final Map<String, ClassField> myResValues;
    private final Collection<File> myProguardFiles;
    private final Collection<File> myConsumerProguardFiles;
    private final Map<String, Object> myManifestPlaceholders;
    private final String myApplicationIdSuffix;
    private final String myVersionNameSuffix;
    private final Boolean myMultiDexEnabled;
    private final int hashCode;

    IdeBaseConfig() {
        this.myName = "";
        this.myResValues = Collections.emptyMap();
        this.myProguardFiles = Collections.emptyList();
        this.myConsumerProguardFiles = Collections.emptyList();
        this.myManifestPlaceholders = Collections.emptyMap();
        this.myApplicationIdSuffix = null;
        this.myVersionNameSuffix = null;
        this.myMultiDexEnabled = null;
        this.hashCode = 0;
    }

    protected IdeBaseConfig(BaseConfig config, ModelCache modelCache) {
        this.myName = config.getName();
        this.myResValues = IdeModel.copy(config.getResValues(), modelCache, classField -> new IdeClassField((ClassField)classField));
        this.myProguardFiles = ImmutableList.copyOf(config.getProguardFiles());
        this.myConsumerProguardFiles = ImmutableList.copyOf(config.getConsumerProguardFiles());
        this.myManifestPlaceholders = config.getManifestPlaceholders().entrySet().stream().collect(ImmutableMap.toImmutableMap(it -> (String)it.getKey(), it -> it.getValue().toString()));
        this.myApplicationIdSuffix = config.getApplicationIdSuffix();
        this.myVersionNameSuffix = IdeModel.copyNewProperty(config::getVersionNameSuffix, null);
        this.myMultiDexEnabled = IdeModel.copyNewProperty(config::getMultiDexEnabled, null);
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Map<String, ClassField> getBuildConfigFields() {
        throw new UnusedModelMethodException("getBuildConfigFields");
    }

    @Override
    public Map<String, ClassField> getResValues() {
        return this.myResValues;
    }

    @Override
    public Collection<File> getProguardFiles() {
        return this.myProguardFiles;
    }

    @Override
    public Collection<File> getConsumerProguardFiles() {
        return this.myConsumerProguardFiles;
    }

    @Override
    public Collection<File> getTestProguardFiles() {
        throw new UnusedModelMethodException("getTestProguardFiles");
    }

    @Override
    public Map<String, Object> getManifestPlaceholders() {
        return this.myManifestPlaceholders;
    }

    @Override
    public String getApplicationIdSuffix() {
        return this.myApplicationIdSuffix;
    }

    @Override
    public String getVersionNameSuffix() {
        return this.myVersionNameSuffix;
    }

    @Override
    public Boolean getMultiDexEnabled() {
        return this.myMultiDexEnabled;
    }

    @Override
    public File getMultiDexKeepFile() {
        throw new UnusedModelMethodException("getMultiDexKeepFile");
    }

    @Override
    public File getMultiDexKeepProguard() {
        throw new UnusedModelMethodException("getMultiDexKeepProguard");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBaseConfig)) {
            return false;
        }
        IdeBaseConfig config = (IdeBaseConfig)o;
        return config.canEqual(this) && Objects.equals(this.myName, config.myName) && Objects.deepEquals(this.myResValues, config.myResValues) && Objects.deepEquals(this.myProguardFiles, config.myProguardFiles) && Objects.deepEquals(this.myConsumerProguardFiles, config.myConsumerProguardFiles) && Objects.deepEquals(this.myManifestPlaceholders, config.myManifestPlaceholders) && Objects.equals(this.myApplicationIdSuffix, config.myApplicationIdSuffix) && Objects.equals(this.myVersionNameSuffix, config.myVersionNameSuffix) && Objects.equals(this.myMultiDexEnabled, config.myMultiDexEnabled);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeBaseConfig;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myName, this.myResValues, this.myProguardFiles, this.myConsumerProguardFiles, this.myManifestPlaceholders, this.myApplicationIdSuffix, this.myVersionNameSuffix, this.myMultiDexEnabled);
    }

    public String toString() {
        return "myName='" + this.myName + '\'' + ", myResValues=" + this.myResValues + ", myProguardFiles=" + this.myProguardFiles + ", myConsumerProguardFiles=" + this.myConsumerProguardFiles + ", myManifestPlaceholders=" + this.myManifestPlaceholders + ", myApplicationIdSuffix='" + this.myApplicationIdSuffix + '\'' + ", myVersionNameSuffix='" + this.myVersionNameSuffix + '\'' + ", myMultiDexEnabled=" + this.myMultiDexEnabled;
    }
}

