/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.gradle.model.level2.IdeDependenciesImpl;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class IdeBaseArtifactImpl
implements IdeBaseArtifact,
Serializable {
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    private static final long serialVersionUID = 6L;
    private final String myName;
    private final String myCompileTaskName;
    private final String myPostAssembleModelFile;
    private final String myAssembleTaskName;
    private final File myClassesFolder;
    private final com.android.ide.common.gradle.model.IdeDependencies myDependencies;
    private final Set<String> myIdeSetupTaskNames;
    private final Set<File> myGeneratedSourceFolders;
    private final Set<File> myAdditionalClassFolders;
    private final IdeDependencies myLevel2Dependencies;
    private final com.android.ide.common.gradle.model.IdeDependencies myCompileDependencies;
    private final File myJavaResourcesFolder;
    private final DependencyGraphs myDependencyGraphs;
    private final IdeSourceProvider myVariantSourceProvider;
    private final IdeSourceProvider myMultiFlavorSourceProvider;
    private final int hashCode;

    IdeBaseArtifactImpl() {
        this.myName = "";
        this.myCompileTaskName = "";
        this.myAssembleTaskName = "";
        this.myPostAssembleModelFile = "";
        this.myClassesFolder = null;
        this.myDependencies = new com.android.ide.common.gradle.model.IdeDependenciesImpl();
        this.myIdeSetupTaskNames = Collections.emptySet();
        this.myGeneratedSourceFolders = Collections.emptySet();
        this.myAdditionalClassFolders = Collections.emptySet();
        this.myLevel2Dependencies = new IdeDependenciesImpl();
        this.myCompileDependencies = null;
        this.myJavaResourcesFolder = null;
        this.myDependencyGraphs = null;
        this.myVariantSourceProvider = null;
        this.myMultiFlavorSourceProvider = null;
        this.hashCode = 0;
    }

    protected IdeBaseArtifactImpl(BaseArtifact artifact, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, GradleVersion modelVersion) {
        this.myName = artifact.getName();
        this.myCompileTaskName = artifact.getCompileTaskName();
        this.myAssembleTaskName = artifact.getAssembleTaskName();
        this.myPostAssembleModelFile = IdeModel.copyNewProperty(artifact::getAssembleTaskOutputListingFile, "");
        this.myClassesFolder = artifact.getClassesFolder();
        this.myJavaResourcesFolder = IdeModel.copyNewProperty(artifact::getJavaResourcesFolder, null);
        this.myDependencies = IdeBaseArtifactImpl.copy(artifact.getDependencies(), modelCache);
        this.myCompileDependencies = IdeModel.copyNewProperty(modelCache, artifact::getCompileDependencies, dependencies -> new com.android.ide.common.gradle.model.IdeDependenciesImpl((Dependencies)dependencies, modelCache), null);
        this.myDependencyGraphs = null;
        this.myIdeSetupTaskNames = ImmutableSet.copyOf(IdeBaseArtifactImpl.getIdeSetupTaskNames(artifact));
        this.myGeneratedSourceFolders = new LinkedHashSet<File>(IdeBaseArtifactImpl.getGeneratedSourceFolders(artifact));
        this.myVariantSourceProvider = IdeBaseArtifactImpl.createSourceProvider(modelCache, artifact.getVariantSourceProvider());
        this.myMultiFlavorSourceProvider = IdeBaseArtifactImpl.createSourceProvider(modelCache, artifact.getMultiFlavorSourceProvider());
        this.myAdditionalClassFolders = IdeModel.copyNewProperty(artifact::getAdditionalClassesFolders, Collections.emptySet());
        this.myLevel2Dependencies = dependenciesFactory.create(artifact);
        this.hashCode = this.calculateHashCode();
    }

    private static com.android.ide.common.gradle.model.IdeDependencies copy(Dependencies original, ModelCache modelCache) {
        return modelCache.computeIfAbsent(original, dependencies -> new com.android.ide.common.gradle.model.IdeDependenciesImpl((Dependencies)dependencies, modelCache));
    }

    private static Set<String> getIdeSetupTaskNames(BaseArtifact artifact) {
        try {
            return ImmutableSet.copyOf(artifact.getIdeSetupTaskNames());
        }
        catch (NoSuchMethodError | UnsupportedOperationException e) {
            if (artifact instanceof AndroidArtifact) {
                return Collections.singleton(((AndroidArtifact)artifact).getSourceGenTaskName());
            }
            return Collections.emptySet();
        }
    }

    private static Collection<File> getGeneratedSourceFolders(BaseArtifact artifact) {
        try {
            Collection<File> folders = artifact.getGeneratedSourceFolders();
            return folders != null ? folders : Collections.emptyList();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Collections.emptyList();
        }
    }

    private static IdeSourceProvider createSourceProvider(ModelCache modelCache, SourceProvider original) {
        return original != null ? modelCache.computeIfAbsent(original, provider -> new IdeSourceProvider((SourceProvider)provider)) : null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getCompileTaskName() {
        return this.myCompileTaskName;
    }

    @Override
    public String getAssembleTaskName() {
        return this.myAssembleTaskName;
    }

    @Override
    public String getAssembleTaskOutputListingFile() {
        return this.myPostAssembleModelFile;
    }

    @Override
    public File getClassesFolder() {
        return this.myClassesFolder;
    }

    @Override
    public File getJavaResourcesFolder() {
        if (this.myJavaResourcesFolder != null) {
            return this.myJavaResourcesFolder;
        }
        throw new UnsupportedOperationException("Unsupported method: BaseArtifact.getJavaResourcesFolder");
    }

    @Override
    public com.android.ide.common.gradle.model.IdeDependencies getDependencies() {
        return this.myDependencies;
    }

    @Override
    public Dependencies getCompileDependencies() {
        if (this.myCompileDependencies != null) {
            return this.myCompileDependencies;
        }
        throw new UnsupportedOperationException("Unsupported method: BaseArtifact.getCompileDependencies()");
    }

    @Override
    public DependencyGraphs getDependencyGraphs() {
        if (this.myDependencyGraphs != null) {
            return this.myDependencyGraphs;
        }
        throw new UnsupportedOperationException("Unsupported method: BaseArtifact.getDependencyGraphs");
    }

    @Override
    public Set<String> getIdeSetupTaskNames() {
        return this.myIdeSetupTaskNames;
    }

    @Override
    public IdeDependencies getLevel2Dependencies() {
        return this.myLevel2Dependencies;
    }

    @Override
    public Collection<File> getGeneratedSourceFolders() {
        return ImmutableList.copyOf(this.myGeneratedSourceFolders);
    }

    @Override
    public void addGeneratedSourceFolder(File generatedSourceFolder) {
        this.myGeneratedSourceFolders.add(generatedSourceFolder);
    }

    @Override
    public IdeSourceProvider getVariantSourceProvider() {
        return this.myVariantSourceProvider;
    }

    @Override
    public IdeSourceProvider getMultiFlavorSourceProvider() {
        return this.myMultiFlavorSourceProvider;
    }

    @Override
    public Set<File> getAdditionalClassesFolders() {
        return this.myAdditionalClassFolders;
    }

    @Override
    public boolean isTestArtifact() {
        return Arrays.asList(TEST_ARTIFACT_NAMES).contains(this.myName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBaseArtifactImpl)) {
            return false;
        }
        IdeBaseArtifactImpl artifact = (IdeBaseArtifactImpl)o;
        return artifact.canEquals(this) && Objects.equals(this.myName, artifact.myName) && Objects.equals(this.myCompileTaskName, artifact.myCompileTaskName) && Objects.equals(this.myAssembleTaskName, artifact.myAssembleTaskName) && Objects.equals(this.myPostAssembleModelFile, artifact.myPostAssembleModelFile) && Objects.equals(this.myClassesFolder, artifact.myClassesFolder) && Objects.equals(this.myAdditionalClassFolders, artifact.myAdditionalClassFolders) && Objects.equals(this.myJavaResourcesFolder, artifact.myJavaResourcesFolder) && Objects.equals(this.myDependencies, artifact.myDependencies) && Objects.equals(this.myLevel2Dependencies, artifact.myLevel2Dependencies) && Objects.equals(this.myCompileDependencies, artifact.myCompileDependencies) && Objects.equals(this.myDependencyGraphs, artifact.myDependencyGraphs) && Objects.equals(this.myIdeSetupTaskNames, artifact.myIdeSetupTaskNames) && Objects.equals(this.myGeneratedSourceFolders, artifact.myGeneratedSourceFolders) && Objects.equals(this.myVariantSourceProvider, artifact.myVariantSourceProvider) && Objects.equals(this.myMultiFlavorSourceProvider, artifact.myMultiFlavorSourceProvider);
    }

    protected boolean canEquals(Object other) {
        return other instanceof IdeBaseArtifactImpl;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myName, this.myCompileTaskName, this.myAssembleTaskName, this.myPostAssembleModelFile, this.myClassesFolder, this.myJavaResourcesFolder, this.myDependencies, this.myLevel2Dependencies, this.myCompileDependencies, this.myDependencyGraphs, this.myIdeSetupTaskNames, this.myGeneratedSourceFolders, this.myVariantSourceProvider, this.myMultiFlavorSourceProvider, this.myAdditionalClassFolders);
    }

    public String toString() {
        return "myName='" + this.myName + '\'' + ", myCompileTaskName='" + this.myCompileTaskName + '\'' + ", myAssembleTaskName='" + this.myAssembleTaskName + '\'' + ", myClassesFolder=" + this.myClassesFolder + ", myJavaResourcesFolder=" + this.myJavaResourcesFolder + ", myDependencies=" + this.myDependencies + ", myLevel2Dependencies" + this.myLevel2Dependencies + ", myCompileDependencies=" + this.myCompileDependencies + ", myDependencyGraphs=" + this.myDependencyGraphs + ", myIdeSetupTaskNames=" + this.myIdeSetupTaskNames + ", myGeneratedSourceFolders=" + this.myGeneratedSourceFolders + ", myVariantSourceProvider=" + this.myVariantSourceProvider + ", myMultiFlavorSourceProvider=" + this.myMultiFlavorSourceProvider;
    }
}

