/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.ApiVersion;
import java.io.Serializable;
import java.util.Objects;

public final class IdeApiVersion
implements ApiVersion,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myApiString;
    private final String myCodename;
    private final int myApiLevel;
    private final int myHashCode;

    IdeApiVersion() {
        this.myApiString = "";
        this.myCodename = null;
        this.myApiLevel = 0;
        this.myHashCode = 0;
    }

    public IdeApiVersion(ApiVersion version) {
        this.myApiString = version.getApiString();
        this.myCodename = version.getCodename();
        this.myApiLevel = version.getApiLevel();
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getApiString() {
        return this.myApiString;
    }

    @Override
    public String getCodename() {
        return this.myCodename;
    }

    @Override
    public int getApiLevel() {
        return this.myApiLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeApiVersion)) {
            return false;
        }
        IdeApiVersion version = (IdeApiVersion)o;
        return this.myApiLevel == version.myApiLevel && Objects.equals(this.myApiString, version.myApiString) && Objects.equals(this.myCodename, version.myCodename);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myApiString, this.myCodename, this.myApiLevel);
    }

    public String toString() {
        return "IdeApiVersion{myApiString='" + this.myApiString + '\'' + ", myCodename='" + this.myCodename + '\'' + ", myApiLevel=" + this.myApiLevel + '}';
    }
}

