/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildInformation;
import com.android.builder.model.ViewBindingOptions;
import com.android.ide.common.gradle.model.IdeAaptOptions;
import com.android.ide.common.gradle.model.IdeAndroidGradlePluginProjectFlags;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBuildTypeContainer;
import com.android.ide.common.gradle.model.IdeDependenciesInfo;
import com.android.ide.common.gradle.model.IdeJavaCompileOptions;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.IdeProductFlavorContainer;
import com.android.ide.common.gradle.model.IdeSigningConfig;
import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.IdeVariantBuildInformation;
import com.android.ide.common.gradle.model.IdeVariantImpl;
import com.android.ide.common.gradle.model.IdeViewBindingOptions;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class IdeAndroidProjectImpl
implements IdeAndroidProject,
Serializable {
    private static final long serialVersionUID = 10L;
    private final String myModelVersion;
    private final String myName;
    private final ProductFlavorContainer myDefaultConfig;
    private final Collection<BuildTypeContainer> myBuildTypes;
    private final Collection<ProductFlavorContainer> myProductFlavors;
    private final Collection<SyncIssue> mySyncIssues;
    private final Collection<IdeVariant> myVariants;
    private final Collection<String> myVariantNames;
    private final String myDefaultVariant;
    private final Collection<String> myFlavorDimensions;
    private final String myCompileTarget;
    private final Collection<String> myBootClassPath;
    private final Collection<NativeToolchain> myNativeToolchains;
    private final Collection<SigningConfig> mySigningConfigs;
    private final IdeLintOptions myLintOptions;
    private final List<File> myLintRuleJars;
    private final Set<String> myUnresolvedDependencies;
    private final JavaCompileOptions myJavaCompileOptions;
    private final AaptOptions myAaptOptions;
    private final File myBuildFolder;
    private final Collection<String> myDynamicFeatures;
    private final Collection<IdeVariantBuildInformation> myVariantBuildInformation;
    private final ViewBindingOptions myViewBindingOptions;
    private final IdeDependenciesInfo myDependenciesInfo;
    private final GradleVersion myParsedModelVersion;
    private final String myBuildToolsVersion;
    private final String myNdkVersion;
    private final String myResourcePrefix;
    private final String myGroupId;
    private final boolean mySupportsPluginGeneration;
    private final int myApiVersion;
    private final int myProjectType;
    private final boolean myBaseSplit;
    private final IdeAndroidGradlePluginProjectFlags myAgpFlags;
    private final int myHashCode;
    private transient Map<String, Object> clientProperties;

    public static IdeAndroidProjectImpl create(AndroidProject project, IdeDependenciesFactory dependenciesFactory, Collection<Variant> variants, @NotNull Collection<SyncIssue> syncIssues) {
        return IdeAndroidProjectImpl.create(project, new ModelCache(), dependenciesFactory, variants, syncIssues);
    }

    @VisibleForTesting
    public static IdeAndroidProjectImpl create(AndroidProject project, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, Collection<Variant> variants, @NotNull Collection<SyncIssue> syncIssues) {
        GradleVersion parsedModelVersion = GradleVersion.tryParse(project.getModelVersion());
        ProductFlavorContainer defaultConfigCopy = modelCache.computeIfAbsent(project.getDefaultConfig(), container -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        List<BuildTypeContainer> buildTypesCopy = IdeModel.copy(project.getBuildTypes(), modelCache, container -> new IdeBuildTypeContainer((BuildTypeContainer)container, modelCache));
        List<ProductFlavorContainer> productFlavorCopy = IdeModel.copy(project.getProductFlavors(), modelCache, container -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        ArrayList<SyncIssue> syncIssuesCopy = new ArrayList<SyncIssue>(IdeModel.copy(syncIssues, modelCache, IdeSyncIssue::new));
        ArrayList<IdeVariant> variantsCopy = new ArrayList<IdeVariant>(IdeModel.copy(variants == null ? project.getVariants() : variants, modelCache, variant -> new IdeVariantImpl((Variant)variant, modelCache, dependenciesFactory, parsedModelVersion)));
        Collection variantNamesCopy = Objects.requireNonNull(IdeModel.copyNewPropertyWithDefault(() -> ImmutableList.copyOf(project.getVariantNames()), () -> IdeAndroidProjectImpl.computeVariantNames(variantsCopy)));
        String defaultVariantCopy = IdeModel.copyNewPropertyWithDefault(project::getDefaultVariant, () -> IdeAndroidProjectImpl.getDefaultVariant(variantNamesCopy));
        Collection flavorDimensionCopy = IdeModel.copyNewPropertyNonNull(() -> ImmutableList.copyOf(project.getFlavorDimensions()), Collections.emptyList());
        ImmutableList<String> bootClasspathCopy = ImmutableList.copyOf(project.getBootClasspath());
        List<NativeToolchain> nativeToolchainsCopy = IdeModel.copy(project.getNativeToolchains(), modelCache, toolChain -> new IdeNativeToolchain((NativeToolchain)toolChain));
        List<SigningConfig> signingConfigsCopy = IdeModel.copy(project.getSigningConfigs(), modelCache, config -> new IdeSigningConfig((SigningConfig)config));
        IdeLintOptions lintOptionsCopy = modelCache.computeIfAbsent(project.getLintOptions(), options -> new IdeLintOptions((LintOptions)options, parsedModelVersion));
        ImmutableSet<String> unresolvedDependenciesCopy = ImmutableSet.copyOf(project.getUnresolvedDependencies());
        IdeJavaCompileOptions javaCompileOptionsCopy = modelCache.computeIfAbsent(project.getJavaCompileOptions(), options -> new IdeJavaCompileOptions((JavaCompileOptions)options));
        IdeAaptOptions aaptOptionsCopy = modelCache.computeIfAbsent(project.getAaptOptions(), options -> new IdeAaptOptions((AaptOptions)options));
        ImmutableList<String> dynamicFeaturesCopy = ImmutableList.copyOf(IdeModel.copyNewPropertyNonNull(project::getDynamicFeatures, ImmutableList.of()));
        Collection<IdeVariantBuildInformation> variantBuildInformation = IdeAndroidProjectImpl.createVariantBuildInformation(project, parsedModelVersion);
        IdeViewBindingOptions viewBindingOptionsCopy = IdeModel.copyNewProperty(() -> new IdeViewBindingOptions(project.getViewBindingOptions()), null);
        IdeDependenciesInfo dependenciesInfoCopy = IdeModel.copyNewProperty(() -> IdeDependenciesInfo.createOrNull(project.getDependenciesInfo()), null);
        String buildToolsVersionCopy = IdeModel.copyNewProperty(project::getBuildToolsVersion, null);
        String ndkVersionCopy = IdeModel.copyNewProperty(project::getNdkVersion, null);
        String groupId = null;
        if (parsedModelVersion != null && parsedModelVersion.isAtLeast(3, 6, 0, "alpha", 5, false)) {
            groupId = project.getGroupId();
        }
        List lintRuleJarsCopy = IdeModel.copyNewProperty(() -> ImmutableList.copyOf(project.getLintRuleJars()), null);
        boolean isBaseSplit = IdeModel.copyNewProperty(project::isBaseSplit, false);
        IdeAndroidGradlePluginProjectFlags agpFlags = Objects.requireNonNull(IdeModel.copyNewProperty(modelCache, project::getFlags, IdeAndroidGradlePluginProjectFlags::new, new IdeAndroidGradlePluginProjectFlags()));
        return new IdeAndroidProjectImpl(project.getModelVersion(), parsedModelVersion, project.getName(), defaultConfigCopy, buildTypesCopy, productFlavorCopy, syncIssuesCopy, variantsCopy, variantNamesCopy, defaultVariantCopy, flavorDimensionCopy, project.getCompileTarget(), bootClasspathCopy, nativeToolchainsCopy, signingConfigsCopy, lintOptionsCopy, lintRuleJarsCopy, unresolvedDependenciesCopy, javaCompileOptionsCopy, aaptOptionsCopy, project.getBuildFolder(), dynamicFeaturesCopy, variantBuildInformation, viewBindingOptionsCopy, dependenciesInfoCopy, buildToolsVersionCopy, ndkVersionCopy, project.getResourcePrefix(), groupId, IdeModel.copyNewProperty(project::getPluginGeneration, null) != null, project.getApiVersion(), IdeAndroidProjectImpl.getProjectType(project, parsedModelVersion), isBaseSplit, agpFlags);
    }

    private IdeAndroidProjectImpl() {
        this.myModelVersion = "";
        this.myParsedModelVersion = null;
        this.myName = "";
        this.myDefaultConfig = new IdeProductFlavorContainer();
        this.myBuildTypes = Collections.emptyList();
        this.myProductFlavors = Collections.emptyList();
        this.mySyncIssues = Collections.emptyList();
        this.myVariants = Collections.emptyList();
        this.myVariantNames = Collections.emptyList();
        this.myDefaultVariant = null;
        this.myFlavorDimensions = Collections.emptyList();
        this.myCompileTarget = "";
        this.myBootClassPath = Collections.emptyList();
        this.myNativeToolchains = Collections.emptyList();
        this.mySigningConfigs = Collections.emptyList();
        this.myLintOptions = new IdeLintOptions();
        this.myLintRuleJars = Collections.emptyList();
        this.myUnresolvedDependencies = Collections.emptySet();
        this.myJavaCompileOptions = new IdeJavaCompileOptions();
        this.myAaptOptions = new IdeAaptOptions();
        this.myBuildFolder = null;
        this.myDynamicFeatures = Collections.emptyList();
        this.myVariantBuildInformation = Collections.emptyList();
        this.myViewBindingOptions = new IdeViewBindingOptions();
        this.myDependenciesInfo = new IdeDependenciesInfo();
        this.myBuildToolsVersion = null;
        this.myNdkVersion = null;
        this.myResourcePrefix = null;
        this.myGroupId = null;
        this.mySupportsPluginGeneration = false;
        this.myApiVersion = 0;
        this.myProjectType = 0;
        this.myBaseSplit = false;
        this.myAgpFlags = new IdeAndroidGradlePluginProjectFlags();
        this.myHashCode = 0;
    }

    private IdeAndroidProjectImpl(String modelVersion, GradleVersion parsedModelVersion, String name, ProductFlavorContainer defaultConfig, Collection<BuildTypeContainer> buildTypes, Collection<ProductFlavorContainer> productFlavors, Collection<SyncIssue> syncIssues, Collection<IdeVariant> variants, Collection<String> variantNames, String defaultVariant, Collection<String> flavorDimensions, String compileTarget, Collection<String> bootClassPath, Collection<NativeToolchain> nativeToolchains, Collection<SigningConfig> signingConfigs, IdeLintOptions lintOptions, List<File> lintRuleJars, Set<String> unresolvedDependencies, JavaCompileOptions javaCompileOptions, AaptOptions aaptOptions, File buildFolder, Collection<String> dynamicFeatures, Collection<IdeVariantBuildInformation> variantBuildInformation, ViewBindingOptions viewBindingOptions, IdeDependenciesInfo dependenciesInfo, String buildToolsVersion, String ndkVersion, String resourcePrefix, String groupId, boolean supportsPluginGeneration, int apiVersion, int projectType, boolean baseSplit, IdeAndroidGradlePluginProjectFlags agpFlags) {
        this.myModelVersion = modelVersion;
        this.myParsedModelVersion = parsedModelVersion;
        this.myName = name;
        this.myDefaultConfig = defaultConfig;
        this.myBuildTypes = buildTypes;
        this.myProductFlavors = productFlavors;
        this.mySyncIssues = syncIssues;
        this.myVariants = variants;
        this.myVariantNames = variantNames;
        this.myDefaultVariant = defaultVariant;
        this.myFlavorDimensions = flavorDimensions;
        this.myCompileTarget = compileTarget;
        this.myBootClassPath = bootClassPath;
        this.myNativeToolchains = nativeToolchains;
        this.mySigningConfigs = signingConfigs;
        this.myLintOptions = lintOptions;
        this.myLintRuleJars = lintRuleJars;
        this.myUnresolvedDependencies = unresolvedDependencies;
        this.myJavaCompileOptions = javaCompileOptions;
        this.myAaptOptions = aaptOptions;
        this.myBuildFolder = buildFolder;
        this.myDynamicFeatures = dynamicFeatures;
        this.myVariantBuildInformation = variantBuildInformation;
        this.myViewBindingOptions = viewBindingOptions;
        this.myDependenciesInfo = dependenciesInfo;
        this.myBuildToolsVersion = buildToolsVersion;
        this.myNdkVersion = ndkVersion;
        this.myResourcePrefix = resourcePrefix;
        this.myGroupId = groupId;
        this.mySupportsPluginGeneration = supportsPluginGeneration;
        this.myApiVersion = apiVersion;
        this.myProjectType = projectType;
        this.myBaseSplit = baseSplit;
        this.myAgpFlags = agpFlags;
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<IdeVariantBuildInformation> createVariantBuildInformation(AndroidProject project, GradleVersion agpVersion) {
        if (agpVersion != null && agpVersion.compareIgnoringQualifiers("4.1.0") >= 0) {
            return project.getVariantsBuildInformation().stream().map(it -> new IdeVariantBuildInformation((VariantBuildInformation)it)).collect(ImmutableList.toImmutableList());
        }
        return Collections.emptyList();
    }

    private static ImmutableList<String> computeVariantNames(Collection<IdeVariant> variants) {
        return variants.stream().map(Variant::getName).collect(ImmutableList.toImmutableList());
    }

    private static int getProjectType(AndroidProject project, GradleVersion modelVersion) {
        if (modelVersion != null && modelVersion.isAtLeast(2, 3, 0)) {
            return project.getProjectType();
        }
        return project.isLibrary() ? 1 : 0;
    }

    @VisibleForTesting
    static String getDefaultVariant(Collection<String> variantNames) {
        if (variantNames.isEmpty()) {
            return null;
        }
        if (variantNames.contains("debug")) {
            return "debug";
        }
        ImmutableSortedSet<String> sortedNames = ImmutableSortedSet.copyOf(variantNames);
        for (String variantName : sortedNames) {
            if (!variantName.endsWith("Debug")) continue;
            return variantName;
        }
        return sortedNames.first();
    }

    @Override
    public GradleVersion getParsedModelVersion() {
        return this.myParsedModelVersion;
    }

    @Override
    public String getModelVersion() {
        return this.myModelVersion;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public ProductFlavorContainer getDefaultConfig() {
        return this.myDefaultConfig;
    }

    @Override
    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.myBuildTypes;
    }

    @Override
    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.myProductFlavors;
    }

    @Override
    public String getBuildToolsVersion() {
        if (this.myBuildToolsVersion != null) {
            return this.myBuildToolsVersion;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidProject.getBuildToolsVersion()");
    }

    @Override
    public String getNdkVersion() {
        return this.myNdkVersion;
    }

    @Override
    public Collection<SyncIssue> getSyncIssues() {
        return ImmutableList.copyOf(this.mySyncIssues);
    }

    @Override
    public Collection<IdeVariant> getVariants() {
        return ImmutableList.copyOf(this.myVariants);
    }

    @Override
    public Collection<String> getVariantNames() {
        return this.myVariantNames;
    }

    @Override
    public String getDefaultVariant() {
        return this.myDefaultVariant;
    }

    @Override
    public Collection<String> getFlavorDimensions() {
        return this.myFlavorDimensions;
    }

    @Override
    public String getCompileTarget() {
        return this.myCompileTarget;
    }

    @Override
    public Collection<String> getBootClasspath() {
        return this.myBootClassPath;
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.myAaptOptions;
    }

    @Override
    public Collection<SigningConfig> getSigningConfigs() {
        return this.mySigningConfigs;
    }

    @Override
    public IdeLintOptions getLintOptions() {
        return this.myLintOptions;
    }

    @Override
    @Deprecated
    public Collection<String> getUnresolvedDependencies() {
        return this.myUnresolvedDependencies;
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.myJavaCompileOptions;
    }

    @Override
    public File getBuildFolder() {
        return this.myBuildFolder;
    }

    @Override
    public String getResourcePrefix() {
        return this.myResourcePrefix;
    }

    @Override
    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Override
    public int getProjectType() {
        return this.myProjectType;
    }

    @Override
    public boolean isBaseSplit() {
        return this.myBaseSplit;
    }

    @Override
    public Collection<String> getDynamicFeatures() {
        return this.myDynamicFeatures;
    }

    @Override
    public ViewBindingOptions getViewBindingOptions() {
        return this.myViewBindingOptions;
    }

    @Override
    public IdeDependenciesInfo getDependenciesInfo() {
        return this.myDependenciesInfo;
    }

    @Override
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    public IdeAndroidGradlePluginProjectFlags getAgpFlags() {
        return this.myAgpFlags;
    }

    @Override
    public void forEachVariant(Consumer<IdeVariant> action) {
        for (Variant variant : this.myVariants) {
            action.accept((IdeVariant)variant);
        }
    }

    @Override
    public void addVariants(Collection<IdeVariant> variants) {
        Set variantNames = this.myVariants.stream().map(variant -> variant.getName()).collect(Collectors.toSet());
        for (IdeVariant variant2 : variants) {
            if (variantNames.contains(variant2.getName())) continue;
            this.myVariants.add(variant2);
        }
    }

    @Override
    public void addSyncIssues(Collection<SyncIssue> syncIssues) {
        HashSet<SyncIssue> currentSyncIssues = new HashSet<SyncIssue>(this.mySyncIssues);
        for (SyncIssue issue : syncIssues) {
            IdeSyncIssue newSyncIssue = new IdeSyncIssue(issue);
            if (currentSyncIssues.contains(newSyncIssue)) continue;
            this.mySyncIssues.add(newSyncIssue);
        }
    }

    @Override
    public Collection<IdeVariantBuildInformation> getVariantsBuildInformation() {
        return this.myVariantBuildInformation;
    }

    @Override
    public List<File> getLintRuleJars() {
        return this.myLintRuleJars;
    }

    @Override
    public Object putClientProperty(String key, Object value) {
        if (value == null) {
            if (this.clientProperties != null) {
                this.clientProperties.remove(key);
            }
        } else {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap<String, Object>();
            }
            this.clientProperties.put(key, value);
        }
        return value;
    }

    @Override
    public Object getClientProperty(String key) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidProjectImpl)) {
            return false;
        }
        IdeAndroidProjectImpl project = (IdeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && this.myProjectType == project.myProjectType && this.myBaseSplit == project.myBaseSplit && this.mySupportsPluginGeneration == project.mySupportsPluginGeneration && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myParsedModelVersion, project.myParsedModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myDefaultConfig, project.myDefaultConfig) && Objects.equals(this.myBuildTypes, project.myBuildTypes) && Objects.equals(this.myProductFlavors, project.myProductFlavors) && Objects.equals(this.myBuildToolsVersion, project.myBuildToolsVersion) && Objects.equals(this.myNdkVersion, project.myNdkVersion) && Objects.equals(this.mySyncIssues, project.mySyncIssues) && Objects.equals(this.myVariants, project.myVariants) && Objects.equals(this.myVariantNames, project.myVariantNames) && Objects.equals(this.myDefaultVariant, project.myDefaultVariant) && Objects.equals(this.myFlavorDimensions, project.myFlavorDimensions) && Objects.equals(this.myCompileTarget, project.myCompileTarget) && Objects.equals(this.myBootClassPath, project.myBootClassPath) && Objects.equals(this.myNativeToolchains, project.myNativeToolchains) && Objects.equals(this.mySigningConfigs, project.mySigningConfigs) && Objects.equals(this.myLintOptions, project.myLintOptions) && Objects.equals(this.myLintRuleJars, project.myLintRuleJars) && Objects.equals(this.myUnresolvedDependencies, project.myUnresolvedDependencies) && Objects.equals(this.myJavaCompileOptions, project.myJavaCompileOptions) && Objects.equals(this.myAaptOptions, project.myAaptOptions) && Objects.equals(this.myBuildFolder, project.myBuildFolder) && Objects.equals(this.myResourcePrefix, project.myResourcePrefix) && Objects.equals(this.myDynamicFeatures, project.myDynamicFeatures) && Objects.equals(this.myViewBindingOptions, project.myViewBindingOptions) && Objects.equals(this.myDependenciesInfo, project.myDependenciesInfo) && Objects.equals(this.myGroupId, project.myGroupId) && Objects.equals(this.myAgpFlags, project.myAgpFlags) && Objects.equals(this.myVariantBuildInformation, project.myVariantBuildInformation);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myParsedModelVersion, this.myName, this.myDefaultConfig, this.myBuildTypes, this.myProductFlavors, this.myBuildToolsVersion, this.myNdkVersion, this.mySyncIssues, this.myVariants, this.myVariantNames, this.myDefaultVariant, this.myFlavorDimensions, this.myCompileTarget, this.myBootClassPath, this.myNativeToolchains, this.mySigningConfigs, this.myLintOptions, this.myLintRuleJars, this.myUnresolvedDependencies, this.myJavaCompileOptions, this.myBuildFolder, this.myResourcePrefix, this.myApiVersion, this.myProjectType, this.mySupportsPluginGeneration, this.myAaptOptions, this.myBaseSplit, this.myDynamicFeatures, this.myViewBindingOptions, this.myDependenciesInfo, this.myGroupId, this.myAgpFlags, this.myVariantBuildInformation);
    }

    public String toString() {
        return "IdeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myDefaultConfig=" + this.myDefaultConfig + ", myBuildTypes=" + this.myBuildTypes + ", myProductFlavors=" + this.myProductFlavors + ", myBuildToolsVersion='" + this.myBuildToolsVersion + ", myNdkVersion='" + this.myNdkVersion + '\'' + ", mySyncIssues=" + this.mySyncIssues + ", myVariants=" + this.myVariants + ", myVariantNames=" + this.myVariantNames + ", myDefaultVariant=" + this.myDefaultVariant + ", myFlavorDimensions=" + this.myFlavorDimensions + ", myCompileTarget='" + this.myCompileTarget + '\'' + ", myBootClassPath=" + this.myBootClassPath + ", myNativeToolchains=" + this.myNativeToolchains + ", mySigningConfigs=" + this.mySigningConfigs + ", myLintOptions=" + this.myLintOptions + ", myUnresolvedDependencies=" + this.myUnresolvedDependencies + ", myJavaCompileOptions=" + this.myJavaCompileOptions + ", myBuildFolder=" + this.myBuildFolder + ", myResourcePrefix='" + this.myResourcePrefix + '\'' + ", myApiVersion=" + this.myApiVersion + ", myProjectType=" + this.myProjectType + ", mySupportsPluginGeneration=" + this.mySupportsPluginGeneration + ", myAaptOptions=" + this.myAaptOptions + ", myBaseSplit=" + this.myBaseSplit + ", myDynamicFeatures=" + this.myDynamicFeatures + ", myViewBindingOptions=" + this.myViewBindingOptions + ", myDependenciesInfo=" + this.myDependenciesInfo + ", myGroupId=" + this.myGroupId + ", myAgpFlags=" + this.myAgpFlags + ", myVariantBuildInformation=" + this.myVariantBuildInformation + "}";
    }
}

