/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidBundle;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.ide.common.gradle.model.IdeAndroidLibrary;
import com.android.ide.common.gradle.model.IdeJavaLibrary;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class IdeAndroidBundle
extends IdeLibrary
implements AndroidBundle {
    private static final long serialVersionUID = 5L;
    private final File myBundle;
    private final File myFolder;
    private final List<? extends AndroidLibrary> myLibraryDependencies;
    private final Collection<? extends JavaLibrary> myJavaDependencies;
    private final File myManifest;
    private final File myJarFile;
    private final File myCompileJarFile;
    private final File myResFolder;
    private final File myResStaticLibrary;
    private final File myAssetsFolder;
    private final String myProjectVariant;
    private final int hashCodeBundle;

    IdeAndroidBundle() {
        this.myBundle = null;
        this.myFolder = null;
        this.myLibraryDependencies = Collections.emptyList();
        this.myJavaDependencies = Collections.emptyList();
        this.myManifest = null;
        this.myJarFile = null;
        this.myCompileJarFile = null;
        this.myResFolder = null;
        this.myResStaticLibrary = null;
        this.myAssetsFolder = null;
        this.myProjectVariant = null;
        this.hashCodeBundle = 0;
    }

    protected IdeAndroidBundle(AndroidBundle bundle, ModelCache modelCache) {
        super(bundle, modelCache);
        this.myBundle = bundle.getBundle();
        this.myFolder = bundle.getFolder();
        this.myLibraryDependencies = IdeModel.copy(bundle.getLibraryDependencies(), modelCache, library -> new IdeAndroidLibrary((AndroidLibrary)library, modelCache));
        this.myJavaDependencies = IdeAndroidBundle.copyJavaDependencies(bundle, modelCache);
        this.myManifest = bundle.getManifest();
        this.myJarFile = bundle.getJarFile();
        this.myCompileJarFile = Preconditions.checkNotNull(IdeModel.copyNewProperty(bundle::getCompileJarFile, this.myJarFile));
        this.myResFolder = bundle.getResFolder();
        this.myResStaticLibrary = IdeModel.copyNewProperty(bundle::getResStaticLibrary, null);
        this.myAssetsFolder = bundle.getAssetsFolder();
        this.myProjectVariant = bundle.getProjectVariant();
        this.hashCodeBundle = this.calculateHashCode();
    }

    private static Collection<? extends JavaLibrary> copyJavaDependencies(AndroidBundle bundle, ModelCache modelCache) {
        Collection<? extends JavaLibrary> javaDependencies;
        try {
            javaDependencies = bundle.getJavaDependencies();
        }
        catch (UnsupportedOperationException ignored) {
            return Collections.emptyList();
        }
        return IdeModel.copy(javaDependencies, modelCache, library -> new IdeJavaLibrary((JavaLibrary)library, modelCache));
    }

    @Override
    public File getBundle() {
        return this.myBundle;
    }

    @Override
    public File getFolder() {
        return this.myFolder;
    }

    @Override
    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.myLibraryDependencies;
    }

    @Override
    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.myJavaDependencies;
    }

    @Override
    public File getManifest() {
        return this.myManifest;
    }

    @Override
    public File getJarFile() {
        return this.myJarFile;
    }

    @Override
    public File getCompileJarFile() {
        return this.myCompileJarFile;
    }

    @Override
    public File getResFolder() {
        return this.myResFolder;
    }

    @Override
    public File getResStaticLibrary() {
        return this.myResStaticLibrary;
    }

    @Override
    public File getAssetsFolder() {
        return this.myAssetsFolder;
    }

    @Override
    public String getProjectVariant() {
        return this.myProjectVariant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidBundle)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidBundle bundle = (IdeAndroidBundle)o;
        return bundle.canEqual(this) && Objects.equals(this.myBundle, bundle.myBundle) && Objects.equals(this.myFolder, bundle.myFolder) && Objects.equals(this.myResStaticLibrary, bundle.myResStaticLibrary) && Objects.equals(this.myLibraryDependencies, bundle.myLibraryDependencies) && Objects.equals(this.myJavaDependencies, bundle.myJavaDependencies) && Objects.equals(this.myManifest, bundle.myManifest) && Objects.equals(this.myJarFile, bundle.myJarFile) && Objects.equals(this.myCompileJarFile, bundle.myCompileJarFile) && Objects.equals(this.myResFolder, bundle.myResFolder) && Objects.equals(this.myAssetsFolder, bundle.myAssetsFolder) && Objects.equals(this.myProjectVariant, bundle.myProjectVariant);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeAndroidBundle;
    }

    @Override
    public int hashCode() {
        return this.hashCodeBundle;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myBundle, this.myFolder, this.myResStaticLibrary, this.myLibraryDependencies, this.myJavaDependencies, this.myManifest, this.myJarFile, this.myCompileJarFile, this.myResFolder, this.myAssetsFolder, this.myProjectVariant);
    }

    @Override
    public String toString() {
        return super.toString() + "myBundle=" + this.myBundle + ", myFolder=" + this.myFolder + ", myNamespacedStaticLibrary=" + this.myResStaticLibrary + ", myLibraryDependencies=" + this.myLibraryDependencies + ", myJavaDependencies=" + this.myJavaDependencies + ", myManifest=" + this.myManifest + ", myJarFile=" + this.myJarFile + ", myCompileJarFile=" + this.myCompileJarFile + ", myResFolder=" + this.myResFolder + ", myAssetsFolder=" + this.myAssetsFolder + ", myProjectVariant='" + this.myProjectVariant + '\'';
    }
}

