/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SplitOutputMatcher {
    public static List<File> computeBestOutputs(DeviceConfigProvider deviceConfigProvider, Collection<OutputFile> outputs, Collection<String> variantAbiFilters) {
        ArrayList<File> apkFiles = new ArrayList<File>();
        List<OutputFile> outputFiles = SplitOutputMatcher.computeBestOutput(outputs, variantAbiFilters, deviceConfigProvider.getAbis());
        for (OutputFile outputFile : outputFiles) {
            apkFiles.add(outputFile.getOutputFile());
        }
        return apkFiles;
    }

    public static <T extends VariantOutput> List<T> computeBestOutput(Collection<? extends T> outputs, Collection<String> variantAbiFilters, List<String> deviceAbis) {
        ArrayList<VariantOutput> matches = Lists.newArrayList();
        for (VariantOutput variantOutput : outputs) {
            String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
            if (abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(variantOutput);
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        VariantOutput match2 = (VariantOutput)Collections.max(matches, (splitOutput, splitOutput2) -> {
            int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            if (rc != 0) {
                return rc;
            }
            int abiOrder1 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput, deviceAbis);
            int abiOrder2 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput2, deviceAbis);
            return abiOrder1 - abiOrder2;
        });
        return SplitOutputMatcher.isMainApkCompatibleWithDevice(match2, variantAbiFilters, deviceAbis) ? ImmutableList.of(match2) : ImmutableList.of();
    }

    private static int getAbiPreferenceOrder(VariantOutput variantOutput, List<String> deviceAbi) {
        String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
        if (Strings.isNullOrEmpty(abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match2 = deviceAbi.indexOf(abiFilter);
        if (match2 == 0) {
            match2 = deviceAbi.size();
        } else if (match2 > 0) {
            match2 = deviceAbi.size() - match2 - 1;
        }
        return match2;
    }

    private static boolean isMainApkCompatibleWithDevice(VariantOutput mainOutputFile, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, OutputFile.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getFilter(VariantOutput variantOutput, String filterType) {
        Collection filters;
        try {
            filters = variantOutput.getFilters();
        }
        catch (UnsupportedOperationException ignored) {
            filters = variantOutput.getOutputs().stream().map(VariantOutput::getFilters).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (FilterData filterData : filters) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }
}

