/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.SourcePosition;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;

class ReadOnlyDocument {
    private final String mFileContents;
    private final List<Integer> myOffsets;
    private File myFile;
    private long myLastModified;

    ReadOnlyDocument(File file) throws IOException {
        String xml = Files.toString(file, Charsets.UTF_8);
        if (xml.startsWith("\ufeff")) {
            xml = xml.substring(1);
        }
        this.mFileContents = xml;
        this.myFile = file;
        this.myLastModified = file.lastModified();
        this.myOffsets = Lists.newArrayListWithExpectedSize(this.mFileContents.length() / 30);
        for (int i2 = 0; i2 < this.mFileContents.length(); ++i2) {
            char c = this.mFileContents.charAt(i2);
            if (c != '\n') continue;
            this.myOffsets.add(i2 + 1);
        }
    }

    public boolean isStale() {
        long now = this.myFile.lastModified();
        return now == 0L || this.myLastModified < now;
    }

    int lineOffset(int lineNumber) {
        int index = lineNumber - 1;
        if (index < 0 || index >= this.myOffsets.size()) {
            return -1;
        }
        return this.myOffsets.get(index);
    }

    int lineNumber(int offset) {
        for (int i2 = 0; i2 < this.myOffsets.size(); ++i2) {
            if (offset >= this.myOffsets.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    SourcePosition sourcePosition(int offset) {
        for (int i2 = 0; i2 < this.myOffsets.size(); ++i2) {
            if (offset >= this.myOffsets.get(i2)) continue;
            int lineStartOffset = i2 == 0 ? 0 : this.myOffsets.get(i2 - 1);
            return new SourcePosition(i2, offset - lineStartOffset, offset);
        }
        return SourcePosition.UNKNOWN;
    }

    int findText(String needle, int offset) {
        Preconditions.checkPositionIndex(offset, this.mFileContents.length());
        return this.mFileContents.indexOf(needle, offset);
    }

    int findTextBackwards(String needle, int offset) {
        Preconditions.checkPositionIndex(offset, this.mFileContents.length());
        return this.mFileContents.lastIndexOf(needle, offset);
    }

    char charAt(int offset) {
        return this.mFileContents.charAt(offset);
    }

    String subsequence(int start, int end) {
        return this.mFileContents.substring(start, end == -1 ? this.mFileContents.length() : end);
    }

    String getContents() {
        return this.mFileContents;
    }

    int length() {
        return this.mFileContents.length();
    }
}

