/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error8Parser
extends AbstractAaptOutputParser {
    private static final Pattern MSG_PATTERN = Pattern.compile("^Invalid configuration: (.+)$");

    Error8Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m3 = MSG_PATTERN.matcher(line);
        if (!m3.matches()) {
            return false;
        }
        String badConfig = m3.group(1);
        String msgText = String.format("APK Configuration filter '%1$s' is invalid", badConfig);
        reader.skipNextLine();
        Message msg = Error8Parser.createMessage(Message.Kind.ERROR, msgText, null, null, "", logger);
        messages.add(msg);
        return true;
    }
}

